/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.ParseException;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Long")
public class StringToLongConverterFactory
implements TypeConverterFactory<String, Long> {
    public TypeConverter<String, Long> createTypeConverter() {
        return new NumberTypeConverter<String, Long>(){

            @Override
            protected Long doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (this.isPercentage()) {
                            return (long)(number.doubleValue() * 100.0);
                        }
                        return number.longValue();
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Long value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return Long.parseLong(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode Long value '" + value + "'.", (Throwable)e);
                }
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Long>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Long>>(String.class, Long.class);
    }
}

