/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.ParseException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

public class StringToShortConverterFactory
implements TypeConverterFactory<String, Short> {
    public TypeConverter<String, Short> createTypeConverter() {
        return new NumberTypeConverter<String, Short>(){

            @Override
            protected Short doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (this.isPercentage()) {
                            return (short)(number.doubleValue() * 100.0);
                        }
                        return number.shortValue();
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Short value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return Short.parseShort(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode Short value '" + value + "'.", (Throwable)e);
                }
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Short>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Short>>(String.class, Short.class);
    }
}

