/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Resource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.StringToDateLocaleAwareConverter;

@Resource(name="XMLGregorianCalendar")
public class StringToXmlGregorianCalendarConverterFactory
implements TypeConverterFactory<String, XMLGregorianCalendar> {
    public TypeConverter<String, XMLGregorianCalendar> createTypeConverter() {
        return new StringToXmlGregorianCalendarConverter();
    }

    public TypeConverterDescriptor<Class<String>, Class<XMLGregorianCalendar>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<XMLGregorianCalendar>>(String.class, XMLGregorianCalendar.class);
    }

    public static class StringToXmlGregorianCalendarConverter
    extends StringToDateLocaleAwareConverter<XMLGregorianCalendar> {
        @Override
        protected XMLGregorianCalendar doConvert(Date date) {
            try {
                GregorianCalendar gregCal = new GregorianCalendar();
                gregCal.setTime(date);
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregCal);
            }
            catch (DatatypeConfigurationException e) {
                throw new TypeConverterException("Error decoding XMLGregorianCalendar data value '" + date + "' with decode format '" + this.format + "'.", (Throwable)e);
            }
        }
    }
}

