/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverterFactory;

public class TypeConverterFactoryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConverterFactoryLoader.class);

    public Set<TypeConverterFactory<?, ?>> load() {
        Iterator<TypeConverterFactory> typeConverterFactoryIterator = ServiceLoader.load(TypeConverterFactory.class).iterator();
        HashSet typeConverterFactories = new HashSet();
        while (typeConverterFactoryIterator.hasNext()) {
            TypeConverterFactory typeConverterFactory = typeConverterFactoryIterator.next();
            this.assertTypeConverterFactoryInterface(typeConverterFactory);
            Type sourceType = ((ParameterizedType)typeConverterFactory.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            Type targetType = ((ParameterizedType)typeConverterFactory.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[1];
            if (typeConverterFactories.contains(typeConverterFactory.getTypeConverterDescriptor())) {
                LOGGER.warn("More than one TypeConverter for type '" + targetType.getTypeName() + "' is installed on the classpath.  You must manually configure decoding of this type, where required.");
                typeConverterFactories.add(null);
                continue;
            }
            typeConverterFactories.add(typeConverterFactory);
        }
        return typeConverterFactories;
    }

    private void assertTypeConverterFactoryInterface(TypeConverterFactory<?, ?> typeConverterFactory) {
        Type[] genericInterfaces = typeConverterFactory.getClass().getGenericInterfaces();
        boolean assertion = false;
        if (genericInterfaces.length >= 1) {
            for (Type type : genericInterfaces) {
                if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(TypeConverterFactory.class)) continue;
                assertion = true;
            }
            if (!assertion) {
                throw new SmooksConfigException(String.format("%s must immediately extend org.smooks.converter.factory.TypeConverterFactory", typeConverterFactory.getClass()));
            }
        } else {
            throw new SmooksConfigException(String.format("%s must extend org.smooks.converter.factory.TypeConverterFactory", typeConverterFactory.getClass()));
        }
    }
}

