/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.delivery.event.ConfigBuilderEvent;
import org.smooks.api.lifecycle.ExecutionLifecycleCleanable;
import org.smooks.api.lifecycle.ExecutionLifecycleInitializable;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.DocumentSelectorStep;

public abstract class AbstractContentDeliveryConfig
implements ContentDeliveryConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContentDeliveryConfig.class);
    private Registry registry;
    private Map<String, List<ResourceConfig>> resourceConfigTable = new LinkedHashMap<String, List<ResourceConfig>>();
    private final Map objectsTable = new LinkedHashMap();
    private final List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private final Set<ExecutionLifecycleInitializable> executionLifecycleInitializables = new LinkedHashSet<ExecutionLifecycleInitializable>();
    private final Set<ExecutionLifecycleCleanable> executionLifecycleCleanables = new LinkedHashSet<ExecutionLifecycleCleanable>();
    private Boolean isDefaultSerializationOn;
    private Boolean closeSource;
    private Boolean closeResult;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public List<ResourceConfig> getResourceConfigs(String selector) {
        return this.resourceConfigTable.get(selector);
    }

    public void setResourceConfigs(Map<String, List<ResourceConfig>> resourceConfigTable) {
        this.resourceConfigTable = resourceConfigTable;
    }

    public Map<String, List<ResourceConfig>> getResourceConfigs() {
        return this.resourceConfigTable;
    }

    public List<?> getObjects(String selector) {
        ArrayList<Object> objects = (ArrayList<Object>)this.objectsTable.get(selector);
        if (objects == null) {
            List<ResourceConfig> resourceConfigs = this.resourceConfigTable.get(selector);
            if (resourceConfigs != null && resourceConfigs.size() > 0) {
                objects = new ArrayList<Object>(resourceConfigs.size());
                if (this.registry == null) {
                    throw new IllegalStateException("Call to getObjects() before the setRegistry() was called.");
                }
                for (ResourceConfig resourceConfig : resourceConfigs) {
                    objects.add(((ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup("class"))).create(resourceConfig));
                }
            } else {
                objects = Collections.EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    public List<ConfigBuilderEvent> getConfigBuilderEvents() {
        return this.configBuilderEvents;
    }

    public boolean isDefaultSerializationOn() {
        if (this.isDefaultSerializationOn == null) {
            this.isDefaultSerializationOn = Boolean.valueOf(ParameterAccessor.getParameterValue("default.serialization.on", String.class, "true", this));
        }
        return this.isDefaultSerializationOn;
    }

    public <T extends Visitor> void addToExecutionLifecycleSets(ContentHandlerBindingIndex<T> contentHandlerBindingIndex) {
        for (List<ContentHandlerBinding<T>> contentHandlerBindings : contentHandlerBindingIndex.values()) {
            for (ContentHandlerBinding<T> contentHandlerBinding : contentHandlerBindings) {
                if (contentHandlerBinding.getContentHandler() instanceof ExecutionLifecycleInitializable) {
                    this.executionLifecycleInitializables.add((ExecutionLifecycleInitializable)contentHandlerBinding.getContentHandler());
                }
                if (!(contentHandlerBinding.getContentHandler() instanceof ExecutionLifecycleCleanable)) continue;
                this.executionLifecycleCleanables.add((ExecutionLifecycleCleanable)contentHandlerBinding.getContentHandler());
            }
        }
    }

    public void executeHandlerInit(ExecutionContext executionContext) {
        for (ExecutionLifecycleInitializable executionLifecycleInitializable : this.executionLifecycleInitializables) {
            executionLifecycleInitializable.executeExecutionLifecycleInitialize(executionContext);
        }
    }

    public void executeHandlerCleanup(ExecutionContext executionContext) {
        for (ExecutionLifecycleCleanable handler : this.executionLifecycleCleanables) {
            try {
                handler.executeExecutionLifecycleCleanup(executionContext);
            }
            catch (Throwable t) {
                LOGGER.error("Error during Visit handler cleanup.", t);
            }
        }
    }

    protected FilterBypass getFilterBypass(ContentHandlerBindingIndex<?> ... contentHandlerBindingIndexes) {
        for (ContentHandlerBindingIndex<?> contentHandlerBindingIndex : contentHandlerBindingIndexes) {
            Collection<List<ContentHandlerBinding<?>>> contentHandlerBindings = contentHandlerBindingIndex.values();
            long userContentHandlerBindingsCount = contentHandlerBindings.stream().flatMap(l -> l.stream().filter(c -> !c.getResourceConfig().isDefaultResource())).count();
            if (userContentHandlerBindingsCount <= 1L) continue;
            return null;
        }
        HashSet<FilterBypass> bypassSet = new HashSet<FilterBypass>();
        for (ContentHandlerBindingIndex<?> contentHandlerBindingIndex : contentHandlerBindingIndexes) {
            Collection<List<ContentHandlerBinding<?>>> contentHandlerBindings = contentHandlerBindingIndex.values();
            long userContentHandlerBindingsCount = contentHandlerBindings.stream().flatMap(l -> l.stream().filter(c -> !c.getResourceConfig().isDefaultResource())).count();
            if (userContentHandlerBindingsCount != 1L) continue;
            FilterBypass filterBypass = this.getFilterBypass((ContentHandlerBindingIndex<T>)contentHandlerBindingIndex);
            if (filterBypass != null) {
                bypassSet.add(filterBypass);
                continue;
            }
            return null;
        }
        if (bypassSet.size() == 1) {
            return (FilterBypass)bypassSet.iterator().next();
        }
        return null;
    }

    private <T extends Visitor> FilterBypass getFilterBypass(ContentHandlerBindingIndex<T> contentHandlerBindingIndex) {
        Set<Map.Entry<String, List<ContentHandlerBinding<T>>>> entries = contentHandlerBindingIndex.entrySet();
        for (Map.Entry<String, List<ContentHandlerBinding<T>>> entry : entries) {
            Visitor visitor;
            ContentHandlerBinding<T> configMap = entry.getValue().get(0);
            ResourceConfig resourceConfig = configMap.getResourceConfig();
            if (resourceConfig.isDefaultResource()) continue;
            if (resourceConfig.getSelectorPath() instanceof IndexedSelectorPath && ((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep() instanceof DocumentSelectorStep && (visitor = (Visitor)configMap.getContentHandler()) instanceof FilterBypass) {
                return (FilterBypass)visitor;
            }
            return null;
        }
        return null;
    }

    protected boolean getCloseSource() {
        if (this.closeSource == null) {
            this.closeSource = Boolean.parseBoolean(ParameterAccessor.getParameterValue("close.source", String.class, "true", this));
        }
        return this.closeSource;
    }

    protected boolean getCloseResult() {
        if (this.closeResult == null) {
            this.closeResult = Boolean.parseBoolean(ParameterAccessor.getParameterValue("close.result", String.class, "true", this));
        }
        return this.closeResult;
    }
}

