/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.Smooks;
import org.smooks.StreamFilterType;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.Filter;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.io.NullReader;
import org.smooks.io.NullWriter;
import org.smooks.io.Stream;
import org.smooks.thread.StackedThreadLocal;

public abstract class AbstractFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFilter.class);
    private static final StackedThreadLocal<Filter> filterThreadLocal = new StackedThreadLocal("Filter");

    public static void setFilterType(Smooks smooks, StreamFilterType filterType) {
        ParameterAccessor.setParameter("stream.filter.type", filterType.toString(), smooks);
    }

    public static Filter getFilter() {
        Filter filter = (Filter)filterThreadLocal.get();
        if (filter == null) {
            throw new IllegalStateException("Call to getFilter() before the filter is set for the Thread.  This method can only be called within the context of a Smooks execution, which sets the filter.");
        }
        return filter;
    }

    public static void setFilter(Filter filter) {
        filterThreadLocal.set((Object)filter);
    }

    public static void removeCurrentFilter() {
        filterThreadLocal.remove();
    }

    protected Reader getReader(Source source, ExecutionContext executionContext) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getReader() != null) {
                return streamSource.getReader();
            }
            if (streamSource.getInputStream() != null) {
                try {
                    if (executionContext != null) {
                        return new InputStreamReader(streamSource.getInputStream(), executionContext.getContentEncoding());
                    }
                    return new InputStreamReader(streamSource.getInputStream(), StandardCharsets.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmooksException("Unable to decode input stream.", (Throwable)e);
                }
            }
            throw new SmooksException("Invalid " + StreamSource.class.getName() + ".  No InputStream or Reader instance.");
        }
        return new NullReader();
    }

    protected Writer getWriter(Result result, ExecutionContext executionContext) {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return streamResult.getWriter();
            }
            if (streamResult.getOutputStream() != null) {
                try {
                    if (executionContext != null) {
                        return new OutputStreamWriter(streamResult.getOutputStream(), executionContext.getContentEncoding());
                    }
                    return new OutputStreamWriter(streamResult.getOutputStream(), StandardCharsets.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmooksException("Unable to encode output stream.", (Throwable)e);
                }
            }
            throw new SmooksException("Invalid " + StreamResult.class.getName() + ".  No OutputStream or Writer instance.");
        }
        if (result instanceof DOMResult) {
            return new StringWriter();
        }
        Writer writer = Stream.out(executionContext);
        if (writer != null) {
            return writer;
        }
        return new NullWriter();
    }

    protected void close(Source source) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            try {
                InputStream inputStream;
                if (streamSource.getReader() != null) {
                    streamSource.getReader().close();
                } else if (streamSource.getInputStream() != null && (inputStream = streamSource.getInputStream()) != System.in) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug("Failed to close input stream/reader.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Result result) {
        block11: {
            if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                try {
                    if (streamResult.getWriter() != null) {
                        try (Writer writer = streamResult.getWriter();){
                            writer.flush();
                            break block11;
                        }
                    }
                    if (streamResult.getOutputStream() == null) break block11;
                    OutputStream stream = streamResult.getOutputStream();
                    try {
                        stream.flush();
                    }
                    finally {
                        if (stream != System.out && stream != System.err) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.debug("Failed to close output stream/writer.  May already be closed.", throwable);
                }
            }
        }
    }
}

