/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.ordering.Sorter;

@NotThreadSafe
public class ContentHandlerBindingIndex<T extends ContentHandler>
implements Map<String, List<ContentHandlerBinding<T>>> {
    private final Map<String, List<ContentHandlerBinding<T>>> contentHandlerBindingsBySelector = new LinkedHashMap<String, List<ContentHandlerBinding<T>>>();

    public void put(String selector, ResourceConfig resourceConfig, T contentHandler) {
        this.put(selector, new DefaultContentHandlerBinding<T>(contentHandler, resourceConfig));
    }

    @Override
    public void put(String selector, ContentHandlerBinding<T> contentHandlerBinding) {
        List contentHandlerBindings = this.contentHandlerBindingsBySelector.computeIfAbsent(selector, k -> new ArrayList());
        contentHandlerBindings.add(contentHandlerBinding);
    }

    public List<ContentHandlerBinding<T>> get(String ... selectors) {
        ArrayList<ContentHandlerBinding<T>> collectedContentHandlerBindings = new ArrayList<ContentHandlerBinding<T>>();
        for (String selector : selectors) {
            List<ContentHandlerBinding<T>> contentHandlerBindings = this.contentHandlerBindingsBySelector.get(selector);
            if (contentHandlerBindings == null) continue;
            collectedContentHandlerBindings.addAll(contentHandlerBindings);
        }
        return collectedContentHandlerBindings;
    }

    @Override
    public int size() {
        return this.contentHandlerBindingsBySelector.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contentHandlerBindingsBySelector.isEmpty();
    }

    @Override
    public boolean containsKey(Object selector) {
        return this.contentHandlerBindingsBySelector.containsKey(selector);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ContentHandlerBinding<T>> get(Object selector) {
        return this.contentHandlerBindingsBySelector.get(selector);
    }

    @Override
    public List<ContentHandlerBinding<T>> put(String selector, List<ContentHandlerBinding<T>> contentHandlerBindings) {
        for (ContentHandlerBinding<T> contentHandlerBinding : contentHandlerBindings) {
            this.put(selector, contentHandlerBinding);
        }
        return contentHandlerBindings;
    }

    @Override
    public List<ContentHandlerBinding<T>> remove(Object key) {
        return this.contentHandlerBindingsBySelector.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<ContentHandlerBinding<T>>> contentHandlerBindingIndex) {
        for (Map.Entry<String, List<ContentHandlerBinding<T>>> entry : contentHandlerBindingIndex.entrySet()) {
            String selector = entry.getKey();
            List<ContentHandlerBinding<T>> contentHandlerBindings = entry.getValue();
            for (ContentHandlerBinding<T> contentHandlerBinding : contentHandlerBindings) {
                this.put(selector, contentHandlerBinding);
            }
        }
    }

    @Override
    public void clear() {
        this.contentHandlerBindingsBySelector.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.contentHandlerBindingsBySelector.keySet());
    }

    @Override
    public Collection<List<ContentHandlerBinding<T>>> values() {
        return Collections.unmodifiableCollection(this.contentHandlerBindingsBySelector.values());
    }

    @Override
    public Set<Map.Entry<String, List<ContentHandlerBinding<T>>>> entrySet() {
        return Collections.unmodifiableSet(this.contentHandlerBindingsBySelector.entrySet());
    }

    public void sort(Sorter.SortOrder sortOrder) {
        Set<Map.Entry<String, List<ContentHandlerBinding<T>>>> tableEntries = this.contentHandlerBindingsBySelector.entrySet();
        for (Map.Entry<String, List<ContentHandlerBinding<T>>> tableEntry : tableEntries) {
            Sorter.sort(tableEntry.getValue(), sortOrder);
        }
    }
}

