/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.smooks.api.ExecutionContext;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.io.DocumentInputSource;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class DOMReader
implements SmooksXMLReader {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    protected static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private AttributesImpl attributes = new AttributesImpl();
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean declareNamespaceAttributes;
    private ExecutionContext executionContext;

    public DOMReader() {
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.FALSE);
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.TRUE);
    }

    public DOMReader(ContentHandler contentHandler) {
        this();
        this.contentHandler = contentHandler;
    }

    public DOMReader(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public DOMReader(ContentHandler contentHandler, LexicalHandler lexicalHandler, EntityResolver entityResolver) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.entityResolver = entityResolver;
    }

    public void write(Node node) throws SAXException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                this.write((Element)node);
                break;
            }
            case 3: {
                this.write(node.getTextContent());
                break;
            }
            case 4: {
                this.write((CDATASection)node);
                break;
            }
            case 5: {
                this.write((Entity)node);
                break;
            }
            case 7: {
                this.write((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.write((Comment)node);
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.write(node);
                break;
            }
            default: {
                throw new SAXException("Invalid node type: " + node);
            }
        }
    }

    public void write(Document document) throws SAXException {
        if (document != null) {
            this.checkForNullHandlers();
            this.documentLocator(document);
            this.startDocument();
            this.entityResolver(document);
            this.dtdHandler(document);
            this.writeContent(document, new Stack<QName>());
            this.endDocument();
        }
    }

    public void write(Element element) throws SAXException {
        this.write(element, new Stack<QName>());
    }

    public void writeOpen(Element element) throws SAXException {
        this.startElement(element, null);
    }

    public void writeClose(Element element) throws SAXException {
        this.endElement(element);
    }

    public void write(String text) throws SAXException {
        if (text != null) {
            char[] chars = text.toCharArray();
            this.contentHandler.characters(chars, 0, chars.length);
        }
    }

    public void write(CDATASection cdata) throws SAXException {
        String text = cdata.getData();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
            this.write(text);
            this.lexicalHandler.endCDATA();
        } else {
            this.write(text);
        }
    }

    public void write(Comment comment) throws SAXException {
        if (this.lexicalHandler != null) {
            String text = comment.getData();
            char[] chars = text.toCharArray();
            this.lexicalHandler.comment(chars, 0, chars.length);
        }
    }

    public void write(Entity entity) throws SAXException {
        String text = entity.getTextContent();
        if (this.lexicalHandler != null) {
            String name = entity.getNodeName();
            this.lexicalHandler.startEntity(name);
            this.write(text);
            this.lexicalHandler.endEntity(name);
        } else {
            this.write(text);
        }
    }

    public void write(ProcessingInstruction pi) throws SAXException {
        String target = pi.getTarget();
        String text = pi.getData();
        this.contentHandler.processingInstruction(target, text);
    }

    public boolean isDeclareNamespaceAttributes() {
        return this.declareNamespaceAttributes;
    }

    public void setDeclareNamespaceAttributes(boolean declareNamespaceAttrs) {
        this.declareNamespaceAttributes = declareNamespaceAttrs;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.setContentHandler(xmlReader.getContentHandler());
        this.setDTDHandler(xmlReader.getDTDHandler());
        this.setEntityResolver(xmlReader.getEntityResolver());
        this.setErrorHandler(xmlReader.getErrorHandler());
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean answer = this.features.get(name);
        return answer != null && answer != false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NAMESPACE_PREFIXES.equals(name)) {
            this.setDeclareNamespaceAttributes(value);
        } else if (FEATURE_NAMESPACE_PREFIXES.equals(name) && !value) {
            String msg = "Namespace feature is always supported in dom4j";
            throw new SAXNotSupportedException(msg);
        }
        this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setProperty(String name, Object value) {
        for (String lexicalHandlerName : LEXICAL_HANDLER_NAMES) {
            if (!lexicalHandlerName.equals(name)) continue;
            this.setLexicalHandler((LexicalHandler)value);
            return;
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (String lexicalHandlerName : LEXICAL_HANDLER_NAMES) {
            if (!lexicalHandlerName.equals(name)) continue;
            return this.getLexicalHandler();
        }
        return this.properties.get(name);
    }

    public void parse(String systemId) throws SAXNotSupportedException {
        throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
    }

    public void parse(InputSource input) throws SAXException {
        if (!(input instanceof DocumentInputSource)) {
            throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
        }
        Document document = ((DocumentInputSource)input).getDocument();
        this.write(document);
    }

    protected void writeContent(Node branch, Stack<QName> namespaceStack) throws SAXException {
        NodeList childNodes = branch.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof Element) {
                this.write((Element)childNode, namespaceStack);
                continue;
            }
            if (childNode instanceof CharacterData) {
                if (childNode instanceof CDATASection) {
                    this.write((CDATASection)childNode);
                    continue;
                }
                if (childNode instanceof Text) {
                    Text text = (Text)childNode;
                    this.write(text.getData());
                    continue;
                }
                if (childNode instanceof Comment) {
                    this.write((Comment)childNode);
                    continue;
                }
                throw new SAXException("Invalid node in DOM content: " + childNode + " of type: " + childNode.getClass());
            }
            if (childNode instanceof Entity) {
                this.write((Entity)childNode);
                continue;
            }
            if (childNode instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)childNode);
                continue;
            }
            throw new SAXException("Invalid node in DOM content: " + childNode);
        }
    }

    protected void documentLocator(Document document) throws SAXException {
        LocatorImpl locator = new LocatorImpl();
        String publicID = null;
        String systemID = null;
        DocumentType docType = document.getDoctype();
        if (docType != null) {
            publicID = docType.getPublicId();
            systemID = docType.getSystemId();
        }
        if (publicID != null) {
            locator.setPublicId(publicID);
        }
        if (systemID != null) {
            locator.setSystemId(systemID);
        }
        locator.setLineNumber(-1);
        locator.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(locator);
    }

    protected void entityResolver(Document document) throws SAXException {
        DocumentType docType;
        if (this.entityResolver != null && (docType = document.getDoctype()) != null) {
            String publicID = docType.getPublicId();
            String systemID = docType.getSystemId();
            if (publicID != null || systemID != null) {
                try {
                    this.entityResolver.resolveEntity(publicID, systemID);
                }
                catch (IOException e) {
                    throw new SAXException("Could not resolve publicID: " + publicID + " systemID: " + systemID, e);
                }
            }
        }
    }

    protected void dtdHandler(Document document) throws SAXException {
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    protected void write(Element element, Stack<QName> namespaceStack) throws SAXException {
        int stackSize = namespaceStack.size();
        AttributesImpl namespaceAttributes = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, namespaceAttributes);
        this.writeContent(element, namespaceStack);
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, stackSize);
    }

    protected AttributesImpl startPrefixMapping(Element element, Stack<QName> namespaceStack) throws SAXException {
        AttributesImpl namespaceAttributes = null;
        String elementNamespace = element.getNamespaceURI();
        String elementLocalName = element.getLocalName() == null ? element.getNodeName() : element.getLocalName();
        QName elementQName = element.getPrefix() == null ? new QName(elementNamespace, elementLocalName) : new QName(elementNamespace, elementLocalName, element.getPrefix());
        if (elementNamespace != null && !this.isIgnoreableNamespace(elementQName, namespaceStack)) {
            namespaceStack.push(elementQName);
            this.contentHandler.startPrefixMapping(element.getPrefix(), elementNamespace);
            namespaceAttributes = this.addNamespaceAttribute(namespaceAttributes, elementQName);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrLocalName;
            Node attribute = attributes.item(i);
            String string = attrLocalName = attribute.getLocalName() == null ? attribute.getNodeName() : attribute.getLocalName();
            if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || !this.isIgnoreableNamespace(new QName(attribute.getNodeValue(), attrLocalName), namespaceStack)) continue;
            QName attrQName = new QName(attribute.getNodeValue(), attrLocalName);
            namespaceStack.push(attrQName);
            this.contentHandler.startPrefixMapping(attrLocalName, attribute.getNodeValue());
            namespaceAttributes = this.addNamespaceAttribute(namespaceAttributes, attrQName);
        }
        return namespaceAttributes;
    }

    protected void endPrefixMapping(Stack<QName> stack, int stackSize) throws SAXException {
        while (stack.size() > stackSize) {
            QName namespace = stack.pop();
            if (namespace == null) continue;
            this.contentHandler.endPrefixMapping(namespace.getPrefix());
        }
    }

    protected void startElement(Element element, AttributesImpl namespaceAttributes) throws SAXException {
        String localName = element.getLocalName() == null ? element.getNodeName() : element.getLocalName();
        this.contentHandler.startElement(element.getNamespaceURI(), localName, this.getQName(element.getPrefix(), localName), this.createAttributes(element, namespaceAttributes));
    }

    protected void endElement(Element element) throws SAXException {
        String localName = element.getLocalName() == null ? element.getNodeName() : element.getLocalName();
        this.contentHandler.endElement(element.getNamespaceURI(), localName, this.getQName(element.getPrefix(), localName));
    }

    protected Attributes createAttributes(Element element, Attributes namespaceAttributes) throws SAXException {
        this.attributes.clear();
        if (namespaceAttributes != null) {
            this.attributes.setAttributes(namespaceAttributes);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String localName = attribute.getLocalName() == null ? attribute.getNodeName() : attribute.getLocalName();
            this.attributes.addAttribute(attribute.getNamespaceURI(), localName, this.getQName(attribute.getPrefix(), localName), "CDATA", attribute.getNodeValue());
        }
        return this.attributes;
    }

    protected AttributesImpl addNamespaceAttribute(AttributesImpl attrs, QName namespace) {
        if (this.declareNamespaceAttributes) {
            String localName;
            if (attrs == null) {
                attrs = new AttributesImpl();
            }
            String prefix = namespace.getPrefix();
            String qualifiedName = "xmlns";
            if (prefix != null && prefix.length() > 0) {
                qualifiedName = "xmlns:" + prefix;
                localName = prefix;
            } else {
                localName = qualifiedName;
            }
            String uri = "";
            String type = "CDATA";
            String value = namespace.getNamespaceURI();
            attrs.addAttribute(uri, localName, qualifiedName, type, value);
        }
        return attrs;
    }

    protected boolean isIgnoreableNamespace(QName namespace, Stack<QName> namespaceStack) {
        if (namespace.getPrefix().equals("") && namespace.getNamespaceURI().equals("") || namespace.getPrefix().equals("xml") && namespace.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        for (QName qName : namespaceStack) {
            if (!qName.getPrefix().equals(namespace.getPrefix()) || !qName.getNamespaceURI().equals(namespace.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    protected void checkForNullHandlers() {
    }

    protected String getQName(String prefix, String localName) {
        return prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

