/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ConfigurationExpander;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentDeliveryConfigBuilder;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.FilterProvider;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.event.ConfigBuilderEvent;
import org.smooks.api.delivery.event.ContentDeliveryConfigBuilderLifecycleEvent;
import org.smooks.api.delivery.event.ContentDeliveryConfigBuilderLifecycleListener;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.JavaContentHandlerFactory;
import org.smooks.engine.delivery.event.DefaultConfigBuilderEvent;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.InstanceLookup;
import org.smooks.engine.lookup.ResourceConfigsProfileSetLookup;
import org.smooks.engine.resource.config.DefaultResourceConfigSortComparator;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class DefaultContentDeliveryConfigBuilder
implements ContentDeliveryConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContentDeliveryConfigBuilder.class);
    private final ProfileSet profileSet;
    private final Registry registry;
    private static final String ELCSPEC_PREFIX = "elcspec:";
    private final List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private final Map<String, List<ResourceConfig>> resourceConfigTable = new LinkedHashMap<String, List<ResourceConfig>>();
    private final List<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
    private final List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private final List<FilterProvider> filterProviders;
    private ContentDeliveryConfig contentDeliveryConfig;

    public DefaultContentDeliveryConfigBuilder(ProfileSet profileSet, Registry registry, List<FilterProvider> filterProviders) {
        AssertArgument.isNotNull((Object)profileSet, (String)"profileSet");
        AssertArgument.isNotNull((Object)registry, (String)"registry");
        AssertArgument.isNotNull(filterProviders, (String)"filterProviders");
        this.profileSet = profileSet;
        this.registry = registry;
        this.filterProviders = filterProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContentDeliveryConfig build(List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) {
        if (this.contentDeliveryConfig != null) return this.contentDeliveryConfig;
        Class<DefaultContentDeliveryConfigBuilder> clazz = DefaultContentDeliveryConfigBuilder.class;
        synchronized (DefaultContentDeliveryConfigBuilder.class) {
            if (this.contentDeliveryConfig != null) return this.contentDeliveryConfig;
            this.load(this.profileSet);
            this.fireEvent(ContentDeliveryConfigBuilderLifecycleEvent.CONTENT_DELIVERY_BUILDER_CREATED);
            this.contentDeliveryConfig = this.buildConfig(extendedContentHandlerBindings);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.contentDeliveryConfig;
        }
    }

    private ContentDeliveryConfig buildConfig(List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) {
        if (extendedContentHandlerBindings != null) {
            this.visitorBindings.addAll(extendedContentHandlerBindings);
        }
        FilterProvider filterProvider = this.getFilterProvider();
        LOGGER.debug(String.format("Activating %s filter", filterProvider.getName()));
        this.configBuilderEvents.add(new DefaultConfigBuilderEvent("SAX/DOM support characteristics of the Resource Configuration map:\n" + this.getResourceFilterCharacteristics()));
        this.configBuilderEvents.add(new DefaultConfigBuilderEvent(String.format("Activating %s filter", filterProvider.getName())));
        ContentDeliveryConfig contentDeliveryConfig = filterProvider.createContentDeliveryConfig(this.visitorBindings, this.registry, this.resourceConfigTable, this.configBuilderEvents);
        this.fireEvent(ContentDeliveryConfigBuilderLifecycleEvent.CONTENT_DELIVERY_CONFIG_CREATED);
        return contentDeliveryConfig;
    }

    private FilterProvider getFilterProvider() {
        List candidateFilterProviders = this.filterProviders.stream().filter(s -> s.isProvider(this.visitorBindings)).collect(Collectors.toList());
        String filterTypeParam = ParameterAccessor.getParameterValue("stream.filter.type", String.class, this.resourceConfigTable);
        if (filterTypeParam == null && candidateFilterProviders.isEmpty()) {
            throw new SmooksException("Ambiguous Resource Configuration set.  All Element Content Handlers must support processing on the SAX and/or DOM Filter:\n" + this.getResourceFilterCharacteristics());
        }
        if (filterTypeParam == null) {
            return (FilterProvider)candidateFilterProviders.get(0);
        }
        Optional<FilterProvider> filterProviderOptional = candidateFilterProviders.stream().filter(c -> c.getName().equalsIgnoreCase(filterTypeParam)).findFirst();
        if (filterProviderOptional.isPresent()) {
            return filterProviderOptional.get();
        }
        throw new SmooksException("The configured Filter ('" + filterTypeParam + "') cannot be used: " + Arrays.toString(candidateFilterProviders.stream().map(FilterProvider::getName).collect(Collectors.toList()).toArray()) + " filters can be used for the given set of visitors. Turn on debug logging for more information.");
    }

    private String getResourceFilterCharacteristics() {
        StringBuffer stringBuf = new StringBuffer();
        ArrayList<ContentHandler> printedHandlers = new ArrayList<ContentHandler>();
        stringBuf.append("\t\tDOM   SAX    Resource  ('x' equals supported)\n");
        stringBuf.append("\t\t---------------------------------------------------------------------\n");
        for (ContentHandlerBinding<Visitor> contentHandlerBinding : this.visitorBindings) {
            this.printHandlerCharacteristics(contentHandlerBinding, stringBuf, printedHandlers);
        }
        stringBuf.append("\n\n");
        return stringBuf.toString();
    }

    private void printHandlerCharacteristics(ContentHandlerBinding<Visitor> contentHandlerBinding, StringBuffer stringBuf, List<ContentHandler> printedHandlers) {
        ContentHandler handler = contentHandlerBinding.getContentHandler();
        if (printedHandlers.contains(handler)) {
            return;
        }
        printedHandlers.add(handler);
        stringBuf.append("\t\t ");
        Map<String, Boolean> supportedFilterProviders = this.filterProviders.stream().map(s -> new AbstractMap.SimpleEntry<String, Boolean>(s.getName(), s.isProvider(Collections.singletonList(contentHandlerBinding)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        for (Map.Entry<String, Boolean> supportedFilterProvider : supportedFilterProviders.entrySet()) {
            stringBuf.append(supportedFilterProvider.getValue() != false ? supportedFilterProvider.getKey() : " ").append("     ");
        }
        stringBuf.append(contentHandlerBinding.getResourceConfig()).append("\n");
    }

    private void load(ProfileSet profileSet) {
        this.resourceConfigs.clear();
        this.resourceConfigs.addAll(Arrays.asList((Object[])this.registry.lookup((Function)new ResourceConfigsProfileSetLookup(this.registry, profileSet))));
        this.buildResourceConfigTable(this.resourceConfigs);
        this.sortResourceConfigs(this.resourceConfigTable, profileSet);
        this.extractContentHandlers();
        this.fireEvent(ContentDeliveryConfigBuilderLifecycleEvent.HANDLERS_CREATED);
        if (LOGGER.isDebugEnabled()) {
            this.logResourceConfig(profileSet);
        }
    }

    private void logResourceConfig(ProfileSet profileSet) {
        LOGGER.debug("==================================================================================================");
        LOGGER.debug("Resource configuration (sorted) for profile [" + profileSet.getBaseProfile() + "].  Sub Profiles: [" + profileSet + "]");
        Iterator<Map.Entry<String, List<ResourceConfig>>> configurations = this.resourceConfigTable.entrySet().iterator();
        int i = 0;
        while (configurations.hasNext()) {
            Map.Entry<String, List<ResourceConfig>> entry = configurations.next();
            List<ResourceConfig> resources = entry.getValue();
            LOGGER.debug(i + ") " + entry.getKey());
            for (int ii = 0; ii < resources.size(); ++ii) {
                LOGGER.debug("\t(" + ii + ") " + resources.get(ii));
            }
        }
        LOGGER.debug("==================================================================================================");
    }

    private void buildResourceConfigTable(List<ResourceConfig> resourceConfigs) {
        for (ResourceConfig resourceConfig : resourceConfigs) {
            this.addResourceConfig(resourceConfig);
        }
    }

    private void addResourceConfig(ResourceConfig config) {
        String target = config.getSelectorPath().getSelector();
        if (config.getSelectorPath().size() > 1) {
            for (int i = config.getSelectorPath().size(); i > 0; --i) {
                SelectorStep selectorStep = (SelectorStep)config.getSelectorPath().get(i - 1);
                if (!(selectorStep instanceof ElementSelectorStep)) continue;
                target = ((ElementSelectorStep)selectorStep).getQName().getLocalPart();
                break;
            }
        }
        this.addResourceConfig(target, config);
    }

    private void addResourceConfig(String element, ResourceConfig resourceConfig) {
        List resourceConfigs;
        if (!this.resourceConfigs.contains(resourceConfig)) {
            this.resourceConfigs.add(resourceConfig);
        }
        if (!(resourceConfigs = this.resourceConfigTable.computeIfAbsent(element, k -> new ArrayList())).contains(resourceConfig)) {
            resourceConfigs.add(resourceConfig);
        }
    }

    private void sortResourceConfigs(Map<String, List<ResourceConfig>> table, ProfileSet profileSet) {
        Parameter<String> sortParam = ParameterAccessor.getParameter("sort.resources", String.class, table);
        if (sortParam != null && ((String)sortParam.getValue()).trim().equalsIgnoreCase("true")) {
            for (Map.Entry<String, List<ResourceConfig>> entry : table.entrySet()) {
                List<ResourceConfig> markupElResourceConfigs = entry.getValue();
                ResourceConfig[] resourceConfigs = markupElResourceConfigs.toArray(new ResourceConfig[0]);
                DefaultResourceConfigSortComparator sortComparator = new DefaultResourceConfigSortComparator(profileSet);
                Arrays.sort(resourceConfigs, sortComparator);
                entry.setValue(new ArrayList<ResourceConfig>(Arrays.asList(resourceConfigs)));
            }
        }
    }

    private void extractContentHandlers() {
        ContentHandlerExtractionStrategy contentHandlerExtractionStrategy = new ContentHandlerExtractionStrategy(this.registry);
        ResourceConfigTableIterator resourceConfigTableIterator = new ResourceConfigTableIterator(contentHandlerExtractionStrategy);
        resourceConfigTableIterator.iterate();
    }

    private void logExecutionEvent(ResourceConfig resourceConfig, String message) {
        this.configBuilderEvents.add(new DefaultConfigBuilderEvent(resourceConfig, message));
    }

    private void fireEvent(ContentDeliveryConfigBuilderLifecycleEvent event) {
        for (Object object : ((Map)this.registry.lookup(new InstanceLookup<ContentDeliveryConfigBuilderLifecycleListener>(ContentDeliveryConfigBuilderLifecycleListener.class))).values()) {
            ((ContentDeliveryConfigBuilderLifecycleListener)object).handle(event);
        }
    }

    private static interface ResourceConfigStrategy {
        public void applyStrategy(ResourceConfig var1);
    }

    private class ResourceConfigTableIterator {
        private final ResourceConfigStrategy strategy;

        private ResourceConfigTableIterator(ResourceConfigStrategy strategy) {
            this.strategy = strategy;
        }

        private void iterate() {
            for (ResourceConfig resourceConfig : DefaultContentDeliveryConfigBuilder.this.resourceConfigs) {
                this.strategy.applyStrategy(resourceConfig);
            }
        }
    }

    private final class ContentHandlerExtractionStrategy
    implements ResourceConfigStrategy {
        private final Registry registry;

        private ContentHandlerExtractionStrategy(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void applyStrategy(ResourceConfig resourceConfig) {
            this.applyContentDeliveryUnitStrategy(resourceConfig);
        }

        private boolean applyContentDeliveryUnitStrategy(ResourceConfig resourceConfig) {
            if (resourceConfig.isJavaResource()) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup("class"));
                if (contentHandlerFactory == null) {
                    throw new SmooksException("No ContentHandlerFactory configured (IoC) for type 'class' (Java).");
                }
                return this.addContentDeliveryUnit(resourceConfig, contentHandlerFactory);
            }
            String resourceType = resourceConfig.getResourceType();
            ContentHandlerFactory<?> contentHandlerFactory = this.tryCreateCreator(resourceType);
            if (contentHandlerFactory != null) {
                if (!(contentHandlerFactory instanceof JavaContentHandlerFactory)) {
                    return this.addContentDeliveryUnit(resourceConfig, contentHandlerFactory);
                }
            } else if (resourceType != null) {
                DefaultContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Unable to create ContentHandler class instance for resource.  This is probably because there's no " + ContentHandlerFactory.class.getSimpleName() + " implementation for resource type '" + resourceType + "' available on the classpath.");
            }
            return false;
        }

        private ContentHandlerFactory<?> tryCreateCreator(String restype) {
            if (restype == null || restype.trim().equals("")) {
                LOGGER.debug("Request to attempt ContentHandlerFactory creation based on a null/empty resource type.");
                return null;
            }
            return (ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup(restype));
        }

        private boolean addContentDeliveryUnit(ResourceConfig resourceConfig, ContentHandlerFactory<?> contentHandlerFactory) {
            List additionalConfigs;
            Object contentHandler;
            try {
                contentHandler = contentHandlerFactory.create(resourceConfig);
            }
            catch (SmooksConfigException e) {
                throw e;
            }
            catch (Throwable thrown) {
                String message = "ContentHandlerFactory [" + contentHandlerFactory.getClass().getName() + "] unable to create resource processing instance for resource [" + resourceConfig + "]. ";
                LOGGER.error(message + thrown.getMessage(), thrown);
                DefaultContentDeliveryConfigBuilder.this.configBuilderEvents.add(new DefaultConfigBuilderEvent(resourceConfig, message, thrown));
                return false;
            }
            if (contentHandler instanceof Visitor) {
                DefaultContentDeliveryConfigBuilder.this.visitorBindings.add(new DefaultContentHandlerBinding<Visitor>((Visitor)contentHandler, resourceConfig));
            }
            if (contentHandler instanceof ConfigurationExpander && (additionalConfigs = ((ConfigurationExpander)contentHandler).expandConfigurations()) != null && !additionalConfigs.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding expansion resource configurations created by: " + resourceConfig);
                    for (ResourceConfig additionalConfig : additionalConfigs) {
                        LOGGER.debug("\tAdding expansion resource configuration: " + additionalConfig);
                    }
                }
                this.processExpansionConfigurations(additionalConfigs);
            }
            if (contentHandler instanceof VisitorAppender) {
                DefaultContentDeliveryConfigBuilder.this.visitorBindings.addAll(((VisitorAppender)contentHandler).addVisitors());
            }
            return true;
        }

        private void processExpansionConfigurations(List<ResourceConfig> additionalConfigs) {
            for (ResourceConfig resourceConfig : additionalConfigs) {
                this.registry.registerResourceConfig(resourceConfig);
                if (this.applyContentDeliveryUnitStrategy(resourceConfig)) continue;
                DefaultContentDeliveryConfigBuilder.this.addResourceConfig(resourceConfig);
            }
        }
    }
}

