/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.smooks.api.delivery.ReaderPool;
import org.xml.sax.XMLReader;

public class DefaultReaderPool
implements ReaderPool {
    private final AtomicReferenceArray<XMLReader> xmlReaderPool;

    public DefaultReaderPool(int maxReaderPoolSize) {
        this.xmlReaderPool = new AtomicReferenceArray(maxReaderPoolSize);
    }

    public XMLReader borrowXMLReader() {
        for (int i = 0; i < this.xmlReaderPool.length(); ++i) {
            XMLReader xmlReader = this.xmlReaderPool.getAndSet(i, null);
            if (xmlReader == null) continue;
            return xmlReader;
        }
        return null;
    }

    public void returnXMLReader(XMLReader xmlReader) {
        for (int i = 0; i < this.xmlReaderPool.length() && !this.xmlReaderPool.compareAndSet(i, null, xmlReader); ++i) {
        }
    }
}

