/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.smooks.api.delivery.ReaderPool;
import org.xml.sax.XMLReader;

public class DynamicReaderPool
implements ReaderPool {
    private final AtomicReference<AtomicReferenceArray<XMLReader>> xmlReaderPoolReference = new AtomicReference();

    public DynamicReaderPool() {
        this.xmlReaderPoolReference.set(new AtomicReferenceArray(16));
    }

    public XMLReader borrowXMLReader() {
        AtomicReferenceArray<XMLReader> readerPool = this.xmlReaderPoolReference.get();
        for (int i = 0; i < readerPool.length(); ++i) {
            XMLReader xmlReader = readerPool.getAndSet(i, null);
            if (xmlReader == null) continue;
            return xmlReader;
        }
        return null;
    }

    public void returnXMLReader(XMLReader xmlReader) {
        AtomicReferenceArray<XMLReader> xmlReaderPool = this.xmlReaderPoolReference.get();
        for (int i = 0; i < xmlReaderPool.length(); ++i) {
            if (!xmlReaderPool.compareAndSet(i, null, xmlReader)) continue;
            return;
        }
        this.xmlReaderPoolReference.compareAndSet(xmlReaderPool, new AtomicReferenceArray(xmlReaderPool.length() * 2));
    }
}

