/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.classpath.ClasspathUtils;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.ClassUtil;

public class JavaContentHandlerFactory
implements ContentHandlerFactory<Object> {
    @Inject
    private ApplicationContext applicationContext;

    public Object create(ResourceConfig resourceConfig) throws SmooksConfigException {
        Object contentHandler;
        try {
            String className = ClasspathUtils.toClassName((String)resourceConfig.getResource());
            Class classRuntime = ClassUtil.forName((String)className, this.getClass());
            try {
                Constructor constructor = classRuntime.getConstructor(DefaultResourceConfig.class);
                contentHandler = constructor.newInstance(resourceConfig);
            }
            catch (NoSuchMethodException e) {
                contentHandler = classRuntime.newInstance();
            }
            ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase(contentHandler, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), resourceConfig, contentHandler)));
            this.applicationContext.getRegistry().registerObject(contentHandler);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SmooksException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", (Throwable)e);
        }
        return contentHandler;
    }

    public String getType() {
        return "class";
    }
}

