/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.dom;

import java.util.HashSet;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.engine.delivery.SmooksContentHandler;
import org.smooks.engine.delivery.replay.EndElementEvent;
import org.smooks.engine.delivery.replay.StartElementEvent;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.xml.DocType;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMBuilder
extends SmooksContentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOMBuilder.class);
    private static final DocumentBuilder documentBuilder;
    private final ExecutionContext execContext;
    private Document ownerDocument;
    private final Stack nodeStack = new Stack();
    private boolean inEntity;
    private final HashSet emptyElements = new HashSet();
    private final StringBuilder cdataNodeBuilder = new StringBuilder();
    private final boolean rewriteEntities;

    public DOMBuilder(ExecutionContext execContext) {
        this(execContext, null);
    }

    public DOMBuilder(ExecutionContext execContext, SmooksContentHandler parentContentHandler) {
        super(execContext, parentContentHandler);
        this.execContext = execContext;
        this.rewriteEntities = Boolean.parseBoolean(ParameterAccessor.getParameterValue("entities.rewrite", String.class, "true", execContext.getContentDeliveryRuntime().getContentDeliveryConfig()));
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.ownerDocument == null) {
            this.ownerDocument = documentBuilder.newDocument();
            this.nodeStack.push(this.ownerDocument);
        }
    }

    public Document getDocument() {
        return this.ownerDocument;
    }

    public void setAppendElement(Element appendElement) {
        this.ownerDocument = appendElement.getOwnerDocument();
        this.nodeStack.push(appendElement);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(StartElementEvent startEvent) throws SAXException {
        Element newElement;
        int attsCount = startEvent.attributes.getLength();
        Node currentNode = (Node)this.nodeStack.peek();
        try {
            newElement = startEvent.uri != null && startEvent.qName != null && !startEvent.qName.equals("") ? this.ownerDocument.createElementNS(startEvent.uri.intern(), startEvent.qName) : this.ownerDocument.createElement(startEvent.localName.intern());
            currentNode.appendChild(newElement);
            if (!this.emptyElements.contains(startEvent.qName != null ? startEvent.qName : startEvent.localName)) {
                this.nodeStack.push(newElement);
            }
        }
        catch (DOMException e) {
            LOGGER.error("DOMException creating start element: namespaceURI=" + startEvent.uri + ", localName=" + startEvent.localName, (Throwable)e);
            throw e;
        }
        for (int i = 0; i < attsCount; ++i) {
            String attNamespace = startEvent.attributes.getURI(i);
            String attQName = startEvent.attributes.getQName(i);
            String attLocalName = startEvent.attributes.getLocalName(i);
            String attValue = startEvent.attributes.getValue(i);
            try {
                if (attNamespace != null && attQName != null) {
                    if ((attNamespace = attNamespace.intern()).equals("")) {
                        if (attQName.startsWith("xmlns")) {
                            attNamespace = "http://www.w3.org/2000/xmlns/";
                        } else if (attQName.startsWith("xml:")) {
                            attNamespace = "http://www.w3.org/XML/1998/namespace";
                        }
                    }
                    newElement.setAttributeNS(attNamespace, attQName, attValue);
                    continue;
                }
                newElement.setAttribute(attLocalName.intern(), attValue);
                continue;
            }
            catch (DOMException e) {
                LOGGER.error("DOMException setting element attribute " + attLocalName + "=" + attValue + "[namespaceURI=" + startEvent.uri + ", localName=" + startEvent.localName + "].", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void endElement(EndElementEvent endEvent) throws SAXException {
        String elName = endEvent.qName != null && !endEvent.qName.equals("") ? endEvent.qName : endEvent.localName;
        if (!this.emptyElements.contains(elName)) {
            int index = this.getIndex(elName);
            if (index != -1) {
                this.nodeStack.setSize(index);
            } else {
                LOGGER.debug("Ignoring unexpected end [" + endEvent.localName + "] element event. Request: [" + this.execContext.getDocumentSource() + "] - document location: [" + this.getCurPath() + "]");
            }
        }
    }

    @Override
    public void close() {
    }

    private String getCurPath() {
        StringBuilder path = new StringBuilder();
        int stackSize = this.nodeStack.size();
        for (int i = 0; i < stackSize; ++i) {
            Node node = (Node)this.nodeStack.elementAt(i);
            if (node.getNodeType() != 1) continue;
            path.append('/').append(((Element)node).getTagName());
        }
        return path.toString();
    }

    private int getIndex(String elName) {
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            Element element;
            Node node = (Node)this.nodeStack.elementAt(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals(elName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            Node currentNode = (Node)this.nodeStack.peek();
            switch (currentNode.getNodeType()) {
                case 1: {
                    if (this.inEntity && !this.rewriteEntities) {
                        currentNode.appendChild(this.ownerDocument.createTextNode("&#" + ch[start] + ";"));
                        break;
                    }
                    currentNode.appendChild(this.ownerDocument.createTextNode(new String(ch, start, length)));
                    break;
                }
                case 4: {
                    this.cdataNodeBuilder.append(ch, start, length);
                    break;
                }
            }
        }
        catch (DOMException e) {
            LOGGER.error("DOMException appending character data [" + new String(ch, start, length) + "]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void startCDATA() throws SAXException {
        CDATASection newCDATASection = this.ownerDocument.createCDATASection("dummy");
        Node currentNode = (Node)this.nodeStack.peek();
        currentNode.appendChild(newCDATASection);
        this.nodeStack.push(newCDATASection);
        this.cdataNodeBuilder.setLength(0);
    }

    @Override
    public void endCDATA() throws SAXException {
        CDATASection cdata = (CDATASection)this.nodeStack.pop();
        cdata.setData(this.cdataNodeBuilder.toString());
        this.cdataNodeBuilder.setLength(0);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            Node currentNode = (Node)this.nodeStack.peek();
            Comment newComment = this.ownerDocument.createComment(new String(ch, start, length));
            currentNode.appendChild(newComment);
        }
        catch (DOMException e) {
            LOGGER.error("DOMException comment data [" + new String(ch, start, length) + "]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.inEntity = true;
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.inEntity = false;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocumentType docType = documentBuilder.getDOMImplementation().createDocumentType(name, publicId, systemId);
        this.ownerDocument.appendChild(docType);
        DocType.setDocType(name, publicId, systemId, null, this.execContext);
    }

    static {
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("XML DOM Parsing environment not configured properly.", e);
        }
    }
}

