/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.lifecycle.VisitLifecycleCleanable;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMVisitAfter;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.api.resource.visitor.dom.VisitPhase;
import org.smooks.engine.delivery.AbstractFilter;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.dom.DOMParser;
import org.smooks.engine.delivery.dom.serialize.Serializer;
import org.smooks.engine.delivery.dom.serialize.TextSerializerVisitor;
import org.smooks.engine.delivery.event.DOMFilterLifecycleEvent;
import org.smooks.engine.delivery.event.ResourceTargetingEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.event.VisitEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.lifecycle.VisitCleanupPhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.report.AbstractReportGenerator;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.resource.config.ResourceConfigurationNotFoundException;
import org.smooks.io.Stream;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaSource;
import org.smooks.support.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmooksDOMFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmooksDOMFilter.class);
    private final ExecutionContext executionContext;
    private final DOMContentDeliveryConfig deliveryConfig;
    private static final TypedKey<Node> DELIVERY_NODE_REQUEST_KEY = new TypedKey();
    private final Boolean closeSource;
    private final Boolean closeResult;
    private final Boolean reverseVisitOrderOnVisitAfter;
    private final ContentDeliveryRuntime contentDeliveryRuntime;
    private final LifecycleManager lifecycleManager;
    private Boolean terminateOnVisitorException;
    private List<ContentHandlerBinding<DOMVisitBefore>> globalAssemblyBefores;
    private List<ContentHandlerBinding<DOMVisitAfter>> globalAssemblyAfters;
    private List<ContentHandlerBinding<DOMVisitBefore>> globalProcessingBefores;
    private List<ContentHandlerBinding<DOMVisitAfter>> globalProcessingAfters;
    private static final String[] GLOBAL_SELECTORS = new String[]{"*", "//"};

    public SmooksDOMFilter(ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in constructor call.");
        }
        this.executionContext = executionContext;
        this.contentDeliveryRuntime = executionContext.getContentDeliveryRuntime();
        this.deliveryConfig = (DOMContentDeliveryConfig)this.contentDeliveryRuntime.getContentDeliveryConfig();
        this.lifecycleManager = (LifecycleManager)executionContext.getApplicationContext().getRegistry().lookup((Function)new LifecycleManagerLookup());
        this.closeSource = Boolean.parseBoolean(ParameterAccessor.getParameterValue("close.source", String.class, "true", this.deliveryConfig));
        this.closeResult = Boolean.parseBoolean(ParameterAccessor.getParameterValue("close.result", String.class, "true", this.deliveryConfig));
        this.reverseVisitOrderOnVisitAfter = Boolean.parseBoolean(ParameterAccessor.getParameterValue("reverse.visit.order.on.visit.after", String.class, "true", this.deliveryConfig));
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            if (!(executionEventListener instanceof AbstractReportGenerator)) continue;
            this.terminateOnVisitorException = false;
        }
        if (this.terminateOnVisitorException == null) {
            this.terminateOnVisitorException = Boolean.parseBoolean(ParameterAccessor.getParameterValue("terminate.on.visitor.exception", String.class, "true", this.deliveryConfig));
        }
    }

    public void doFilter() throws SmooksException {
        Source source = FilterSource.getSource(this.executionContext);
        Result result = FilterResult.getResult(this.executionContext, StreamResult.class);
        if (result == null) {
            result = FilterResult.getResult(this.executionContext, DOMResult.class);
        }
        this.doFilter(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilter(Source source, Result result) {
        if (!(source instanceof StreamSource || source instanceof DOMSource || source instanceof JavaSource)) {
            throw new IllegalArgumentException(source.getClass().getName() + " Source types not yet supported by the DOM Filter.");
        }
        if (!(result instanceof FilterResult || result == null || result instanceof StreamResult || result instanceof DOMResult)) {
            throw new IllegalArgumentException(result.getClass().getName() + " Result types not yet supported by the DOM Filter.");
        }
        try {
            Node resultNode;
            if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                if (node instanceof Document) {
                    resultNode = this.filter((Document)node);
                } else {
                    if (!(node instanceof Element)) throw new IllegalArgumentException("DOMSource Source types must contain a Document or Element node.");
                    resultNode = this.filter((Element)node);
                }
            } else {
                resultNode = this.filter(source);
            }
            if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = this.getWriter(streamResult, this.executionContext);
                try {
                    this.serialize(resultNode, writer);
                    writer.flush();
                    return;
                }
                catch (IOException e) {
                    LOGGER.debug("Error writing result to output stream.", (Throwable)e);
                }
                return;
            } else {
                if (!(result instanceof DOMResult)) return;
                ((DOMResult)result).setNode(resultNode);
            }
            return;
        }
        finally {
            if (this.closeSource.booleanValue()) {
                this.close(source);
            }
            if (this.closeResult.booleanValue()) {
                this.close(result);
            }
        }
    }

    public void close() {
    }

    public Node filter(Source source) {
        Node deliveryNode;
        if (source == null) {
            throw new IllegalArgumentException("null 'source' arg passed in method call.");
        }
        try {
            DOMParser parser = new DOMParser(this.executionContext);
            Document document = parser.parse(source);
            deliveryNode = this.filter(document);
        }
        catch (Exception cause) {
            throw new SmooksException("Unable to filter InputStream for target profile [" + this.executionContext.getTargetProfiles().getBaseProfile() + "].", (Throwable)cause);
        }
        return deliveryNode;
    }

    public Node filter(Document doc) {
        if (doc.getDocumentElement() == null) {
            LOGGER.debug("Empty Document [" + this.executionContext.getDocumentSource() + "].  Not performaing any processing.");
            return doc;
        }
        Node deliveryNode = this.filter(doc.getDocumentElement());
        if (deliveryNode == null) {
            deliveryNode = doc;
        }
        return deliveryNode;
    }

    public Node filter(final Element element) {
        this.executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, (Object)new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(cbuf, off, len);
                Element resultNode = TextSerializerVisitor.createTextElement(element, stringWriter.toString());
                DomUtils.replaceNode(resultNode, (Node)element);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        ContentHandlerBindingIndex<DOMVisitBefore> visitBeforeContentHandlerBindingIndex = this.deliveryConfig.getAssemblyVisitBeforeIndex();
        ContentHandlerBindingIndex<DOMVisitAfter> visitAfterContentHandlerBindingIndex = this.deliveryConfig.getAssemblyVisitAfterIndex();
        this.globalAssemblyBefores = visitBeforeContentHandlerBindingIndex.get(GLOBAL_SELECTORS);
        this.globalAssemblyAfters = visitAfterContentHandlerBindingIndex.get(GLOBAL_SELECTORS);
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent((ExecutionEvent)new DOMFilterLifecycleEvent(DOMFilterLifecycleEvent.DOMEventType.ASSEMBLY_STARTED, this.executionContext));
        }
        if (this.applyAssembly(visitBeforeContentHandlerBindingIndex, visitAfterContentHandlerBindingIndex)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting assembly phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
            }
            this.assemble(element, true);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No assembly units configured for device [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent((ExecutionEvent)new DOMFilterLifecycleEvent(DOMFilterLifecycleEvent.DOMEventType.PROCESSING_STARTED, this.executionContext));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting processing phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        this.globalProcessingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get(GLOBAL_SELECTORS);
        if (this.globalProcessingBefores != null && this.globalProcessingBefores.isEmpty()) {
            this.globalProcessingBefores = null;
        }
        this.globalProcessingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get(GLOBAL_SELECTORS);
        if (this.globalProcessingAfters != null && this.globalProcessingAfters.isEmpty()) {
            this.globalProcessingAfters = null;
        }
        ArrayList<ElementProcessor> transList = new ArrayList<ElementProcessor>();
        this.buildProcessingList(transList, element, true);
        int transListLength = transList.size();
        for (int i = 0; i < transListLength; ++i) {
            ElementProcessor elementTrans = (ElementProcessor)transList.get(i);
            elementTrans.process(this.executionContext);
        }
        return (Node)this.executionContext.get(DELIVERY_NODE_REQUEST_KEY);
    }

    private boolean applyAssembly(ContentHandlerBindingIndex<DOMVisitBefore> visitBefores, ContentHandlerBindingIndex<DOMVisitAfter> visitAfters) {
        return !visitBefores.isEmpty() || !visitAfters.isEmpty() || this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty() || this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty();
    }

    private void assemble(Element element, boolean isRoot) {
        List<ContentHandlerBinding<DOMVisitAfter>> elementVisitAfters;
        List<ContentHandlerBinding<DOMVisitBefore>> elementVisitBefores;
        List<Node> nodeListCopy = this.copyList(element.getChildNodes());
        ContentHandlerBindingIndex<DOMVisitBefore> visitBeforeTable = this.deliveryConfig.getAssemblyVisitBeforeIndex();
        ContentHandlerBindingIndex<DOMVisitAfter> visitAfterTable = this.deliveryConfig.getAssemblyVisitAfterIndex();
        String elementName = DomUtils.getName(element);
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent(new StartFragmentEvent<Node>(new NodeFragment(element)));
        }
        if (isRoot) {
            elementVisitBefores = visitBeforeTable.get("#document", elementName);
            elementVisitAfters = visitAfterTable.get("#document", elementName);
        } else {
            elementVisitBefores = visitBeforeTable.get((Object)elementName);
            elementVisitAfters = visitAfterTable.get((Object)elementName);
        }
        if (elementVisitBefores != null && !elementVisitBefores.isEmpty()) {
            this.applyAssemblyBefores(element, elementVisitBefores);
        }
        if (this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty()) {
            this.applyAssemblyBefores(element, this.globalAssemblyBefores);
        }
        for (Node aNodeListCopy : nodeListCopy) {
            Node child = aNodeListCopy;
            if (child.getNodeType() != 1) continue;
            this.assemble((Element)child, false);
        }
        if (elementVisitAfters != null && !elementVisitAfters.isEmpty()) {
            this.applyAssemblyAfters(element, elementVisitAfters);
        }
        if (this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty()) {
            this.applyAssemblyAfters(element, this.globalAssemblyAfters);
        }
    }

    private void applyAssemblyBefores(Element element, List<ContentHandlerBinding<DOMVisitBefore>> assemblyBefores) {
        NodeFragment nodeFragment = new NodeFragment(element);
        for (ContentHandlerBinding<DOMVisitBefore> configMap : assemblyBefores) {
            ResourceConfig resourceConfig = configMap.getResourceConfig();
            if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), this.executionContext)) continue;
            for (Object executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent((ExecutionEvent)new ResourceTargetingEvent((Fragment)nodeFragment, resourceConfig, VisitSequence.BEFORE, VisitPhase.ASSEMBLY));
            }
            DOMVisitBefore assemblyUnit = (DOMVisitBefore)configMap.getContentHandler();
            try {
                Object executionEventListener;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("(Assembly) Calling visitBefore on element [" + DomUtils.getXPath(element) + "]. Config [" + resourceConfig + "]");
                }
                assemblyUnit.visitBefore(element, this.executionContext);
                executionEventListener = this.contentDeliveryRuntime.getExecutionEventListeners().iterator();
                while (executionEventListener.hasNext()) {
                    ExecutionEventListener executionEventListener2 = (ExecutionEventListener)executionEventListener.next();
                    executionEventListener2.onEvent(new VisitEvent<Node, DOMVisitBefore>(nodeFragment, configMap, VisitSequence.BEFORE, this.executionContext));
                }
            }
            catch (Throwable e) {
                String errorMsg = "(Assembly) visitBefore failed [" + assemblyUnit.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
                this.processVisitorException(nodeFragment, e, configMap, VisitSequence.BEFORE, errorMsg);
            }
        }
    }

    private void applyAssemblyAfters(Element element, List<ContentHandlerBinding<DOMVisitAfter>> elementVisitAfters) {
        if (this.reverseVisitOrderOnVisitAfter.booleanValue()) {
            for (int i = elementVisitAfters.size() - 1; i >= 0; --i) {
                ContentHandlerBinding<DOMVisitAfter> configMap = elementVisitAfters.get(i);
                this.applyAssemblyAfter(element, configMap);
            }
        } else {
            for (ContentHandlerBinding<DOMVisitAfter> configMap : elementVisitAfters) {
                this.applyAssemblyAfter(element, configMap);
            }
        }
    }

    private void applyAssemblyAfter(Element element, ContentHandlerBinding<DOMVisitAfter> visitAfterBinding) {
        NodeFragment nodeFragment = new NodeFragment(element);
        ResourceConfig resourceConfig = visitAfterBinding.getResourceConfig();
        if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), this.executionContext)) {
            return;
        }
        DOMVisitAfter visitAfter = (DOMVisitAfter)visitAfterBinding.getContentHandler();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("(Assembly) Calling visitAfter on element [" + DomUtils.getXPath(element) + "]. Config [" + resourceConfig + "]");
            }
            visitAfter.visitAfter(element, this.executionContext);
            for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent(new VisitEvent<Node, DOMVisitAfter>(nodeFragment, visitAfterBinding, VisitSequence.AFTER, this.executionContext));
            }
        }
        catch (Throwable e) {
            String errorMsg = "(Assembly) visitAfter failed [" + visitAfter.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
            this.processVisitorException(nodeFragment, e, visitAfterBinding, VisitSequence.AFTER, errorMsg);
        }
    }

    private void buildProcessingList(List<ElementProcessor> processingList, Element element, boolean isRoot) {
        ElementProcessor processor;
        List<ContentHandlerBinding<VisitLifecycleCleanable>> processingCleanables;
        List<ContentHandlerBinding<DOMVisitAfter>> processingAfters;
        List<ContentHandlerBinding<DOMVisitBefore>> processingBefores;
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent(new StartFragmentEvent<Node>(new NodeFragment(element)));
        }
        String elementName = DomUtils.getName(element);
        if (isRoot) {
            processingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get("#document", elementName);
            processingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get("#document", elementName);
            processingCleanables = this.deliveryConfig.getVisitLifecycleCleanableIndex().get("#document", elementName);
        } else {
            processingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get((Object)elementName);
            processingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get((Object)elementName);
            processingCleanables = this.deliveryConfig.getVisitLifecycleCleanableIndex().get((Object)elementName);
        }
        if (processingBefores != null && !processingBefores.isEmpty()) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(processingBefores);
            processingList.add(processor);
        }
        if (this.globalProcessingBefores != null) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(this.globalProcessingBefores);
            processingList.add(processor);
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.buildProcessingList(processingList, (Element)child, false);
        }
        if (processingAfters != null && !processingAfters.isEmpty()) {
            ElementProcessor processor2 = new ElementProcessor(element);
            processor2.setVisitAfters(processingAfters);
            processingList.add(processor2);
        }
        if (this.globalProcessingAfters != null) {
            ElementProcessor processor3 = new ElementProcessor(element);
            processor3.setVisitAfters(this.globalProcessingAfters);
            processingList.add(processor3);
        }
        if (processingCleanables != null && !processingCleanables.isEmpty()) {
            ElementProcessor processor4 = new ElementProcessor(element);
            processor4.setVisitCleanables(processingCleanables);
            processingList.add(processor4);
        }
    }

    public void serialize(Node node, Writer writer) throws IOException, SmooksException {
        if (node == null) {
            throw new IllegalArgumentException("null 'doc' arg passed in method call.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting serialization phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        Serializer serializer = new Serializer(node, this.executionContext);
        try {
            serializer.serialize(writer);
        }
        catch (ResourceConfigurationNotFoundException e) {
            throw new SmooksException("Unable to serialize document.", (Throwable)e);
        }
    }

    private List<Node> copyList(NodeList nodeList) {
        ArrayList<Node> copy = new ArrayList<Node>(nodeList.getLength());
        int nodeCount = nodeList.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            copy.add(nodeList.item(i));
        }
        return copy;
    }

    private void processVisitorException(Fragment<?> fragment, Throwable error, ContentHandlerBinding<? extends Visitor> configMapping, VisitSequence visitSequence, String errorMsg) throws SmooksException {
        for (ExecutionEventListener executionEventListener : this.executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
            executionEventListener.onEvent(new VisitEvent(fragment, configMapping, visitSequence, this.executionContext, error));
        }
        this.executionContext.setTerminationError(error);
        if (this.terminateOnVisitorException.booleanValue()) {
            if (error instanceof SmooksException) {
                throw (SmooksException)error;
            }
            throw new SmooksException(errorMsg, error);
        }
        LOGGER.debug(errorMsg, error);
    }

    private class ElementProcessor {
        private final Element element;
        private List<ContentHandlerBinding<DOMVisitBefore>> visitBefores;
        private List<ContentHandlerBinding<DOMVisitAfter>> visitAfters;
        private List<ContentHandlerBinding<VisitLifecycleCleanable>> visitCleanables;

        private ElementProcessor(Element element) {
            this.element = element;
        }

        private void setVisitBefores(List<ContentHandlerBinding<DOMVisitBefore>> visitBefores) {
            this.visitBefores = visitBefores;
        }

        private void setVisitAfters(List<ContentHandlerBinding<DOMVisitAfter>> visitAfters) {
            this.visitAfters = visitAfters;
        }

        public void setVisitCleanables(List<ContentHandlerBinding<VisitLifecycleCleanable>> visitCleanables) {
            this.visitCleanables = visitCleanables;
        }

        private void process(ExecutionContext executionContext) {
            if (this.visitBefores != null) {
                for (ContentHandlerBinding<DOMVisitBefore> visitBefore : this.visitBefores) {
                    this.processMapping(executionContext, visitBefore, VisitSequence.BEFORE);
                }
            } else if (this.visitAfters != null) {
                int loopLength = this.visitAfters.size();
                if (SmooksDOMFilter.this.reverseVisitOrderOnVisitAfter.booleanValue()) {
                    for (int i = loopLength - 1; i >= 0; --i) {
                        ContentHandlerBinding<DOMVisitAfter> configMap = this.visitAfters.get(i);
                        this.processMapping(executionContext, configMap, VisitSequence.AFTER);
                    }
                } else {
                    for (ContentHandlerBinding<DOMVisitAfter> visitAfter : this.visitAfters) {
                        this.processMapping(executionContext, visitAfter, VisitSequence.AFTER);
                    }
                }
            } else {
                for (ContentHandlerBinding<VisitLifecycleCleanable> visitCleanable : this.visitCleanables) {
                    this.processMapping(executionContext, visitCleanable, VisitSequence.CLEAN);
                }
            }
        }

        private void processMapping(ExecutionContext executionContext, ContentHandlerBinding<? extends Visitor> visitorBinding, VisitSequence visitSequence) {
            NodeFragment nodeFragment = new NodeFragment(this.element);
            ResourceConfig resourceConfig = visitorBinding.getResourceConfig();
            if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), executionContext)) {
                return;
            }
            if (visitSequence == VisitSequence.BEFORE) {
                for (Object executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent((ExecutionEvent)new ResourceTargetingEvent((Fragment)nodeFragment, resourceConfig, VisitSequence.BEFORE, new Object[0]));
                }
                DOMVisitBefore visitor = (DOMVisitBefore)visitorBinding.getContentHandler();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Applying processing resource [" + resourceConfig + "] to element [" + DomUtils.getXPath(this.element) + "] before applying resources to its child elements.");
                    }
                    visitor.visitBefore(this.element, executionContext);
                    for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                        executionEventListener.onEvent(new VisitEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.BEFORE, executionContext));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.AFTER) {
                for (Object executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent((ExecutionEvent)new ResourceTargetingEvent((Fragment)nodeFragment, resourceConfig, VisitSequence.AFTER, new Object[0]));
                }
                DOMVisitAfter visitor = (DOMVisitAfter)visitorBinding.getContentHandler();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Applying processing resource [" + resourceConfig + "] to element [" + DomUtils.getXPath(this.element) + "] after applying resources to its child elements.");
                    }
                    visitor.visitAfter(this.element, executionContext);
                    for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                        executionEventListener.onEvent(new VisitEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.AFTER, executionContext));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.CLEAN) {
                for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent((ExecutionEvent)new ResourceTargetingEvent((Fragment)nodeFragment, resourceConfig, VisitSequence.CLEAN, new Object[0]));
                }
                ContentHandler contentHandler = visitorBinding.getContentHandler();
                if (contentHandler instanceof VisitLifecycleCleanable) {
                    VisitLifecycleCleanable visitor = (VisitLifecycleCleanable)contentHandler;
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Cleaning up processing resource [" + resourceConfig + "] that was targeted to element [" + DomUtils.getXPath(this.element) + "].");
                        }
                        SmooksDOMFilter.this.lifecycleManager.applyPhase((Object)visitor, (LifecyclePhase)new VisitCleanupPhase(nodeFragment, executionContext));
                        for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                            executionEventListener.onEvent(new VisitEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.CLEAN, executionContext));
                        }
                    }
                    catch (Throwable e) {
                        String errorMsg = "Failed to clean up [" + visitor.getClass().getName() + "]. Targeted at [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                        SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.CLEAN, errorMsg);
                    }
                }
            }
        }
    }
}

