/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.engine.delivery.event.FilterLifecycleEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.event.VisitEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.expression.MVELExpressionEvaluator;

public class BasicExecutionEventListener
implements ExecutionEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicExecutionEventListener.class);
    private final List<ExecutionEvent> events = new ArrayList<ExecutionEvent>();
    private List<? extends Class<? extends ExecutionEvent>> filterEvents;

    public void setFilterEvents(Class<? extends ExecutionEvent> ... filterEvents) {
        this.filterEvents = filterEvents != null ? Arrays.asList(filterEvents) : null;
    }

    public void onEvent(ExecutionEvent executionEvent) {
        if (this.ignoreEvent(executionEvent)) {
            return;
        }
        if (executionEvent != null) {
            this.events.add(executionEvent);
        } else {
            LOGGER.warn("Invalid call to onEvent method.  null 'event' arg.");
        }
    }

    protected boolean ignoreEvent(ExecutionEvent event) {
        if (event instanceof FilterLifecycleEvent) {
            return false;
        }
        if (event instanceof StartFragmentEvent) {
            return false;
        }
        if (this.filterEvents != null && !this.filterEvents.contains(event.getClass())) {
            return true;
        }
        if (event instanceof VisitEvent) {
            VisitEvent visitEvent = (VisitEvent)event;
            ContentHandler handler = visitEvent.getVisitorBinding().getContentHandler();
            if (visitEvent.getSequence() == VisitSequence.BEFORE) {
                VisitBeforeReport reportAnnotation = handler.getClass().getAnnotation(VisitBeforeReport.class);
                if (reportAnnotation != null) {
                    return !this.evalReportCondition(visitEvent, reportAnnotation.condition());
                }
            } else {
                VisitAfterReport reportAnnotation = handler.getClass().getAnnotation(VisitAfterReport.class);
                if (reportAnnotation != null) {
                    return !this.evalReportCondition(visitEvent, reportAnnotation.condition());
                }
            }
        }
        return false;
    }

    private boolean evalReportCondition(VisitEvent visitEvent, String condition) {
        MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
        conditionEval.setExpression(condition);
        return conditionEval.eval(visitEvent.getResourceConfig());
    }

    public List<ExecutionEvent> getEvents() {
        return this.events;
    }
}

