/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.event.ResourceTargetingEvent;
import org.smooks.engine.delivery.event.VisitEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public class EventInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor {
    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (this.getTarget().getContentHandler() instanceof BeforeVisitor) {
            for (ExecutionEventListener executionEventListener : executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
                executionEventListener.onEvent((ExecutionEvent)new ResourceTargetingEvent((Fragment)new NodeFragment(element), this.getTarget().getResourceConfig(), VisitSequence.BEFORE, new Object[0]));
            }
            this.intercept(this.visitBeforeInvocation, element, executionContext);
            this.onEvent(executionContext, new NodeFragment(element), VisitSequence.BEFORE);
        } else {
            this.intercept(this.visitBeforeInvocation, element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        this.intercept(this.visitAfterInvocation, element, executionContext);
        if (this.getTarget().getContentHandler() instanceof AfterVisitor) {
            this.onEvent(executionContext, new NodeFragment(element), VisitSequence.AFTER);
        }
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        this.intercept(this.visitChildTextInvocation, characterData, executionContext);
        if (this.getTarget().getContentHandler() instanceof ChildrenVisitor) {
            this.onEvent(executionContext, new NodeFragment(characterData), VisitSequence.AFTER);
        }
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        this.intercept(this.visitChildElementInvocation, childElement, executionContext);
        if (this.getTarget().getContentHandler() instanceof ChildrenVisitor) {
            this.onEvent(executionContext, new NodeFragment(childElement.getParentNode()), VisitSequence.AFTER);
        }
    }

    private void onEvent(ExecutionContext executionContext, Fragment fragment, VisitSequence visitSequence) {
        for (ExecutionEventListener executionEventListener : executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
            executionEventListener.onEvent(new VisitEvent(fragment, this.getTarget(), visitSequence, executionContext));
        }
    }
}

