/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.event.VisitEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.smooks.engine.delivery.sax.ng.terminate.TerminateException;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public class ExceptionInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor,
DOMElementVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionInterceptor.class);
    protected boolean terminateOnVisitorException;
    protected String visitBeforeExceptionMessage;
    protected String visitAfterExceptionMessage;
    protected String visitChildTextExceptionMessage;
    private String visitChildElementExceptionMessage;

    @PostConstruct
    public void postConstructor() {
        this.terminateOnVisitorException = Boolean.parseBoolean((String)((ResourceConfig)this.applicationContext.getRegistry().lookup((Function)new GlobalParamsLookup(this.applicationContext.getRegistry()))).getParameterValue("terminate.on.visitor.exception", String.class, (Object)"true"));
        this.visitBeforeExceptionMessage = String.format("Error in %s while processing visitBefore SAX NG event", ((Visitor)this.visitorBinding.getContentHandler()).getClass().getName());
        this.visitAfterExceptionMessage = String.format("Error in %s while processing visitAfter SAX NG event", ((Visitor)this.visitorBinding.getContentHandler()).getClass().getName());
        this.visitChildTextExceptionMessage = String.format("Error in %s while processing visitChildText SAX NG event", ((Visitor)this.visitorBinding.getContentHandler()).getClass().getName());
        this.visitChildElementExceptionMessage = String.format("Error in %s while processing visitChildElement SAX NG event", ((Visitor)this.visitorBinding.getContentHandler()).getClass().getName());
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        this.intercept(this.visitBeforeInvocation, executionContext, this.visitBeforeExceptionMessage, new NodeFragment(element), VisitSequence.BEFORE, element, executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        this.intercept(this.visitAfterInvocation, executionContext, this.visitAfterExceptionMessage, new NodeFragment(element), VisitSequence.AFTER, element, executionContext);
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        this.intercept(this.visitChildTextInvocation, executionContext, this.visitChildTextExceptionMessage, new NodeFragment(characterData), VisitSequence.AFTER, characterData, executionContext);
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        this.intercept(this.visitChildElementInvocation, executionContext, this.visitChildElementExceptionMessage, new NodeFragment(childElement.getParentNode()), VisitSequence.AFTER, childElement, executionContext);
    }

    private <T extends Visitor> void intercept(AbstractInterceptorVisitor.Invocation<T> invocation, ExecutionContext executionContext, String exceptionMessage, Fragment<?> fragment, VisitSequence visitSequence, Object ... invocationArgs) {
        try {
            this.intercept(invocation, invocationArgs);
        }
        catch (Throwable t) {
            this.processVisitorException(t, exceptionMessage, executionContext, fragment, visitSequence, (ContentHandlerBinding<Visitor>)this.visitorBinding);
        }
    }

    private void processVisitorException(Throwable t, String exceptionMessage, ExecutionContext executionContext, Fragment<?> fragment, VisitSequence visitSequence, ContentHandlerBinding<Visitor> visitorBinding) {
        for (ExecutionEventListener executionEventListener : executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
            executionEventListener.onEvent(new VisitEvent(fragment, visitorBinding, visitSequence, executionContext, t));
        }
        if (t instanceof TerminateException) {
            throw (TerminateException)t;
        }
        executionContext.setTerminationError(t);
        if (this.terminateOnVisitorException) {
            if (t instanceof SmooksException) {
                throw (SmooksException)t;
            }
            throw new SmooksException(exceptionMessage, t);
        }
        LOGGER.error(exceptionMessage, t);
    }
}

