/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.interceptor.InterceptorVisitor;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorDefinition;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;

public class InterceptorVisitorChainFactory {
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;
    protected final List<InterceptorVisitorDefinition> interceptorVisitorDefinitions = new ArrayList<InterceptorVisitorDefinition>();

    public ContentHandlerBinding<Visitor> createInterceptorChain(ContentHandlerBinding<Visitor> visitorBinding) {
        if (this.interceptorVisitorDefinitions.isEmpty()) {
            return visitorBinding;
        }
        ContentHandlerBinding<Visitor> interceptedVisitorBinding = visitorBinding;
        for (InterceptorVisitorDefinition interceptorVisitorDefinition : this.interceptorVisitorDefinitions) {
            InterceptorVisitor interceptorVisitor;
            try {
                interceptorVisitor = interceptorVisitorDefinition.getInterceptorVisitorClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
            interceptorVisitor.setVisitorBinding(interceptedVisitorBinding);
            DefaultResourceConfig interceptorResourceConfig = new DefaultResourceConfig(visitorBinding.getResourceConfig());
            if (interceptorVisitorDefinition.getSelector().isPresent()) {
                interceptorResourceConfig.setSelector(interceptorVisitorDefinition.getSelector().get(), interceptorResourceConfig.getSelectorPath().getNamespaces());
            }
            ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)interceptorVisitor, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), interceptorResourceConfig, interceptorVisitor)));
            interceptedVisitorBinding = new DefaultContentHandlerBinding<InterceptorVisitor>(interceptorVisitor, interceptorResourceConfig);
        }
        return interceptedVisitorBinding;
    }

    public List<InterceptorVisitorDefinition> getInterceptorVisitorDefinitions() {
        return this.interceptorVisitorDefinitions;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

