/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.sax.StreamResultWriter;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.api.resource.visitor.interceptor.InterceptorVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.smooks.engine.memento.SimpleVisitorMemento;
import org.smooks.io.FragmentWriter;
import org.smooks.io.Stream;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class StreamResultWriterInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor,
DOMElementVisitor,
InterceptorVisitor {
    protected boolean isStreamResultWriter;

    @PostConstruct
    public void postConstruct() {
        this.isStreamResultWriter = ((Visitor)this.getTarget().getContentHandler()).getClass().isAnnotationPresent(StreamResultWriter.class);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        if (this.isStreamResultWriter) {
            this.intercept(this.visitAfterInvocation, new StreamResultWriterDelegateElement(element), executionContext);
        } else {
            this.intercept(this.visitAfterInvocation, element, executionContext);
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (this.isStreamResultWriter) {
            this.intercept(this.visitBeforeInvocation, new StreamResultWriterDelegateElement(element), executionContext);
        } else {
            this.intercept(this.visitBeforeInvocation, element, executionContext);
        }
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        if (this.isStreamResultWriter) {
            this.intercept(this.visitChildTextInvocation, new StreamResultWriterDelegateCharacterData(characterData), executionContext);
        } else {
            this.intercept(this.visitChildTextInvocation, characterData, executionContext);
        }
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        if (this.isStreamResultWriter) {
            this.intercept(this.visitChildElementInvocation, new StreamResultWriterDelegateElement(childElement), executionContext);
        } else {
            this.intercept(this.visitChildElementInvocation, childElement, executionContext);
        }
    }

    protected <T extends Visitor> void intercept(AbstractInterceptorVisitor.Invocation<T> invocation, StreamResultWriterDelegateNode streamResultWriterDelegateNode, ExecutionContext executionContext) {
        NodeFragment nodeFragment = new NodeFragment(streamResultWriterDelegateNode.getDelegateNode());
        executionContext.getMementoCaretaker().stash(new SimpleVisitorMemento<FragmentWriter>(nodeFragment, (Visitor)this, new FragmentWriter(executionContext, nodeFragment, false)), writerMemento -> {
            try {
                ((FragmentWriter)writerMemento.getState()).park();
            }
            catch (IOException e) {
                throw new SmooksException((Throwable)e);
            }
            executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, writerMemento.getState());
            super.intercept(invocation, streamResultWriterDelegateNode, executionContext);
            executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, (Object)((FragmentWriter)writerMemento.getState()).getDelegateWriter());
            return writerMemento;
        });
    }

    static class StreamResultWriterDelegateElement
    extends StreamResultWriterDelegateNode
    implements Element {
        private final Element element;

        StreamResultWriterDelegateElement(Element element) {
            super(element);
            this.element = element;
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            this.element.setAttribute(name, value);
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            this.element.removeAttribute(name);
        }

        @Override
        public Attr getAttributeNode(String name) {
            return this.element.getAttributeNode(name);
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            return this.element.setAttributeNode(newAttr);
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            return this.element.removeAttributeNode(oldAttr);
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return this.element.getElementsByTagName(name);
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNS(namespaceURI, localName);
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            this.element.setAttributeNS(namespaceURI, qualifiedName, value);
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            this.element.removeAttributeNS(namespaceURI, localName);
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            return this.element.setAttributeNodeNS(newAttr);
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getElementsByTagNameNS(namespaceURI, localName);
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.element.getSchemaTypeInfo();
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            this.element.setIdAttribute(name, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            this.element.setIdAttributeNS(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            this.element.setIdAttributeNode(idAttr, isId);
        }
    }

    static class StreamResultWriterDelegateCharacterData
    extends StreamResultWriterDelegateNode
    implements CharacterData {
        private final CharacterData characterData;

        StreamResultWriterDelegateCharacterData(CharacterData characterData) {
            super(characterData);
            this.characterData = characterData;
        }

        @Override
        public String getData() throws DOMException {
            return this.characterData.getData();
        }

        @Override
        public void setData(String data) throws DOMException {
            this.characterData.setData(data);
        }

        @Override
        public int getLength() {
            return this.characterData.getLength();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            return this.characterData.substringData(offset, count);
        }

        @Override
        public void appendData(String arg) throws DOMException {
            this.characterData.appendData(arg);
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            this.characterData.insertData(offset, arg);
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            this.characterData.deleteData(offset, count);
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            this.characterData.replaceData(offset, count, arg);
        }
    }

    static abstract class StreamResultWriterDelegateNode
    implements Node {
        private final Node node;

        StreamResultWriterDelegateNode(Node node) {
            this.node = node;
        }

        @Override
        public String getNodeName() {
            return this.node.getNodeName();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.node.getNodeValue();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.node.setNodeValue(nodeValue);
        }

        @Override
        public short getNodeType() {
            return this.node.getNodeType();
        }

        @Override
        public Node getParentNode() {
            return this.node.getParentNode();
        }

        @Override
        public NodeList getChildNodes() {
            return this.node.getChildNodes();
        }

        @Override
        public Node getFirstChild() {
            return this.node.getFirstChild();
        }

        @Override
        public Node getLastChild() {
            return this.node.getLastChild();
        }

        @Override
        public Node getPreviousSibling() {
            return this.node.getPreviousSibling();
        }

        @Override
        public Node getNextSibling() {
            return this.node.getNextSibling();
        }

        @Override
        public NamedNodeMap getAttributes() {
            return this.node.getAttributes();
        }

        @Override
        public Document getOwnerDocument() {
            return this.node.getOwnerDocument();
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            return this.node.insertBefore(newChild, refChild);
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            return this.node.replaceChild(newChild, oldChild);
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            return this.node.removeChild(oldChild);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            return this.node.appendChild(newChild);
        }

        @Override
        public boolean hasChildNodes() {
            return this.node.hasChildNodes();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this.node.cloneNode(deep);
        }

        @Override
        public void normalize() {
            this.node.normalize();
        }

        @Override
        public boolean isSupported(String feature, String version) {
            return this.node.isSupported(feature, version);
        }

        @Override
        public String getNamespaceURI() {
            return this.node.getNamespaceURI();
        }

        @Override
        public String getPrefix() {
            return this.node.getPrefix();
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            this.node.setPrefix(prefix);
        }

        @Override
        public String getLocalName() {
            return this.node.getLocalName();
        }

        @Override
        public boolean hasAttributes() {
            return this.node.hasAttributes();
        }

        @Override
        public String getBaseURI() {
            return this.node.getBaseURI();
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            return this.node.compareDocumentPosition(other);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.node.getTextContent();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.node.setTextContent(textContent);
        }

        @Override
        public boolean isSameNode(Node other) {
            return this.node.isSameNode(other);
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            return this.node.lookupPrefix(namespaceURI);
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return this.node.isDefaultNamespace(namespaceURI);
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return this.node.lookupNamespaceURI(prefix);
        }

        @Override
        public boolean isEqualNode(Node arg) {
            return this.node.isEqualNode(arg);
        }

        @Override
        public Object getFeature(String feature, String version) {
            return this.node.getFeature(feature, version);
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return this.node.setUserData(key, data, handler);
        }

        @Override
        public Object getUserData(String key) {
            Object userData = this.node.getUserData(key);
            if ("reservations".equals(key)) {
                HashMap reservedTokens = new HashMap((Map)userData);
                reservedTokens.remove(0L);
                return reservedTokens;
            }
            return userData;
        }

        public Node getDelegateNode() {
            return this.node;
        }
    }
}

