/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.ordering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.assertion.AssertArgument;

public class Sorter {
    private Sorter() {
    }

    public static <T extends ContentHandler> void sort(List<ContentHandlerBinding<T>> visitors, SortOrder sortOrder) throws SmooksConfigException {
        List<DependencySpec> dependancySpecs = Sorter.buildDependencyMap(visitors);
        Sorter.assertNo2WayDependencies(dependancySpecs);
        Sorter.sortDependancyMap(dependancySpecs, sortOrder);
        Sorter.remapList(dependancySpecs, visitors);
    }

    private static <T extends ContentHandler> List<DependencySpec> buildDependencyMap(List<ContentHandlerBinding<T>> visitors) {
        ArrayList<DependencySpec> dependancySpecs = new ArrayList<DependencySpec>();
        for (ContentHandlerBinding<T> visitor : visitors) {
            dependancySpecs.add(new DependencySpec(visitor));
        }
        for (DependencySpec outer : dependancySpecs) {
            Set outerProducts;
            if (!(outer.visitor.getContentHandler() instanceof Producer) || (outerProducts = ((Producer)outer.visitor.getContentHandler()).getProducts()).isEmpty()) continue;
            for (DependencySpec inner : dependancySpecs) {
                if (inner == outer || !(inner.visitor.getContentHandler() instanceof Consumer)) continue;
                Consumer innerConsumer = (Consumer)inner.visitor.getContentHandler();
                for (Object product : outerProducts) {
                    if (!innerConsumer.consumes(product)) continue;
                    outer.dependants.add(inner);
                }
            }
        }
        return dependancySpecs;
    }

    private static void sortDependancyMap(List<DependencySpec> dependancySpecs, SortOrder sortOrder) {
        boolean iterate = true;
        while (iterate) {
            iterate = Sorter.applySort(dependancySpecs);
        }
        DependencySpec[] array = new DependencySpec[dependancySpecs.size()];
        dependancySpecs.toArray(array);
        Arrays.sort(array, new Comparator<DependencySpec>(){

            @Override
            public int compare(DependencySpec left, DependencySpec right) {
                int rightScore;
                int leftScore = this.score(left);
                if (leftScore > (rightScore = this.score(right))) {
                    return -1;
                }
                if (leftScore < rightScore) {
                    return 1;
                }
                return 0;
            }

            private int score(DependencySpec spec) {
                int score = 0;
                if (spec.visitor.getContentHandler() instanceof Producer) {
                    score += 2;
                }
                if (spec.visitor.getContentHandler() instanceof Consumer) {
                    --score;
                }
                return score;
            }
        });
        dependancySpecs.clear();
        if (sortOrder == SortOrder.PRODUCERS_FIRST) {
            dependancySpecs.addAll(Arrays.asList(array));
        } else {
            for (DependencySpec spec : array) {
                dependancySpecs.add(0, spec);
            }
        }
    }

    private static boolean applySort(List<DependencySpec> dependencySpecs) {
        int specCount = dependencySpecs.size();
        for (int i = 0; i < specCount; ++i) {
            DependencySpec dependancy = dependencySpecs.get(i);
            for (int ii = 0; ii < dependancy.dependants.size(); ++ii) {
                List dependants = dependancy.dependants;
                DependencySpec dependant = (DependencySpec)dependants.get(ii);
                int dependantIndex = dependencySpecs.indexOf(dependant);
                if (dependantIndex >= i) continue;
                dependencySpecs.remove(i);
                dependencySpecs.add(dependantIndex, dependancy);
                return true;
            }
        }
        return false;
    }

    private static <T extends ContentHandler> void remapList(List<DependencySpec> dependancySpecs, List<ContentHandlerBinding<T>> visitors) {
        visitors.clear();
        for (DependencySpec dependancySpec : dependancySpecs) {
            visitors.add(dependancySpec.visitor);
        }
    }

    private static void assertNo2WayDependencies(List<DependencySpec> dependancySpecs) throws SmooksConfigException {
        Stack<DependencySpec> dependencyStack = new Stack<DependencySpec>();
        for (DependencySpec spec : dependancySpecs) {
            dependencyStack.push(spec);
            Sorter.assertNo2WayDependencies(spec, spec.dependants, dependencyStack);
            dependencyStack.pop();
        }
    }

    private static void assertNo2WayDependencies(DependencySpec spec, List<DependencySpec> dependancySpecs, Stack<DependencySpec> dependencyStack) {
        for (DependencySpec dependancy : dependancySpecs) {
            dependencyStack.push(dependancy);
            if (dependancy.isDependant(spec)) {
                dependencyStack.push(spec);
                throw new SmooksConfigException("Invalid 2-Way/Circular Visitor Producer/Consumer dependency detected in configuration.\n" + Sorter.getDependencyStackTrace(dependencyStack));
            }
            Sorter.assertNo2WayDependencies(spec, dependancy.dependants, dependencyStack);
            dependencyStack.pop();
        }
    }

    private static String getDependencyStackTrace(Stack<DependencySpec> dependencyStack) {
        StringBuilder builder = new StringBuilder();
        int numTabs = 0;
        Sorter.appendTabs(++numTabs, builder);
        builder.append(dependencyStack.pop().visitor.getResourceConfig());
        builder.append("\n");
        while (!dependencyStack.isEmpty()) {
            Sorter.appendTabs(++numTabs, builder);
            builder.append("depends-on: ");
            builder.append(dependencyStack.pop().visitor.getResourceConfig());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static void appendTabs(int count, StringBuilder builder) {
        for (int i = 0; i < count; ++i) {
            builder.append('\t');
        }
    }

    private static class DependencySpec<T extends ContentHandler> {
        private final ContentHandlerBinding<T> visitor;
        private final List<DependencySpec> dependants = new ArrayList<DependencySpec>();

        private DependencySpec(ContentHandlerBinding<T> visitor) {
            AssertArgument.isNotNull(visitor, (String)"visitor");
            this.visitor = visitor;
        }

        private boolean isDependant(DependencySpec visitor) {
            if (visitor == this) {
                throw new IllegalStateException("Unexpected call to 'isDependant' with this Visitor.");
            }
            for (DependencySpec dependant : this.dependants) {
                if (dependant != visitor) continue;
                return true;
            }
            return false;
        }
    }

    public static enum SortOrder {
        PRODUCERS_FIRST,
        CONSUMERS_FIRST;

    }
}

