/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ConfigBuilderEvent;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.engine.delivery.AbstractFilterProvider;
import org.smooks.engine.delivery.event.DefaultConfigBuilderEvent;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorChainFactory;
import org.smooks.engine.delivery.sax.ng.SaxNgContentDeliveryConfig;
import org.smooks.engine.lookup.InterceptorVisitorFactoryLookup;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class SaxNgFilterProvider
extends AbstractFilterProvider {
    public SaxNgContentDeliveryConfig createContentDeliveryConfig(List<ContentHandlerBinding<Visitor>> visitorBindings, Registry registry, Map<String, List<ResourceConfig>> resourceConfigTable, List<ConfigBuilderEvent> configBuilderEvents) {
        SaxNgContentDeliveryConfig saxNgContentDeliveryConfig = new SaxNgContentDeliveryConfig();
        InterceptorVisitorChainFactory interceptorVisitorChainFactory = (InterceptorVisitorChainFactory)registry.lookup((Function)new InterceptorVisitorFactoryLookup());
        for (ContentHandlerBinding<Visitor> visitorBinding : visitorBindings) {
            visitorBinding.getResourceConfig().getSelectorPath().setNamespaces((Properties)registry.lookup((Function)new NamespaceManagerLookup()));
            if (!(visitorBinding.getContentHandler() instanceof BeforeVisitor) && !(visitorBinding.getContentHandler() instanceof AfterVisitor)) continue;
            if (visitorBinding.getContentHandler() instanceof BeforeVisitor || visitorBinding.getContentHandler() instanceof ChildrenVisitor) {
                this.assertSelectorsNotAccessingText(visitorBinding.getResourceConfig());
            }
            ContentHandlerBinding<Visitor> interceptorChain = interceptorVisitorChainFactory.createInterceptorChain(visitorBinding);
            Visitor interceptorChainVisitor = (Visitor)interceptorChain.getContentHandler();
            String selector = null;
            if (interceptorChain.getResourceConfig().getSelectorPath() instanceof IndexedSelectorPath) {
                for (int i = interceptorChain.getResourceConfig().getSelectorPath().size(); i > 0; --i) {
                    SelectorStep selectorStep = (SelectorStep)interceptorChain.getResourceConfig().getSelectorPath().get(i - 1);
                    if (!(selectorStep instanceof ElementSelectorStep)) continue;
                    selector = ((ElementSelectorStep)selectorStep).getQName().getLocalPart();
                    break;
                }
            } else {
                selector = "*";
            }
            if (interceptorChainVisitor instanceof BeforeVisitor && this.visitBeforeAnnotationsOK(visitorBinding.getContentHandler())) {
                saxNgContentDeliveryConfig.getBeforeVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (BeforeVisitor)interceptorChainVisitor);
                if (interceptorChainVisitor instanceof ChildrenVisitor) {
                    saxNgContentDeliveryConfig.getChildVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor)interceptorChainVisitor);
                }
            }
            if (interceptorChainVisitor instanceof AfterVisitor && this.visitAfterAnnotationsOK(visitorBinding.getContentHandler())) {
                saxNgContentDeliveryConfig.getAfterVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (AfterVisitor)interceptorChainVisitor);
                if (!(interceptorChainVisitor instanceof BeforeVisitor) && interceptorChainVisitor instanceof ChildrenVisitor) {
                    saxNgContentDeliveryConfig.getChildVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor)interceptorChainVisitor);
                }
            }
            configBuilderEvents.add(new DefaultConfigBuilderEvent(interceptorChain.getResourceConfig(), "Added as a SAX NG visitor."));
        }
        saxNgContentDeliveryConfig.setRegistry(registry);
        saxNgContentDeliveryConfig.setResourceConfigs(resourceConfigTable);
        saxNgContentDeliveryConfig.getConfigBuilderEvents().addAll(configBuilderEvents);
        saxNgContentDeliveryConfig.addToExecutionLifecycleSets();
        return saxNgContentDeliveryConfig;
    }

    protected void assertSelectorsNotAccessingText(ResourceConfig resourceConfig) {
        if (resourceConfig.getSelectorPath() instanceof IndexedSelectorPath && ((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep() instanceof ElementSelectorStep && ((ElementSelectorStep)((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep()).accessesText()) {
            throw new SmooksConfigException("Unsupported selector '" + resourceConfig.getSelectorPath().getSelector() + "' on resource '" + resourceConfig + "'.  The 'text()' XPath token is only supported on SAX Visitor implementations that implement the " + AfterVisitor.class.getName() + " interface only.  Class '" + resourceConfig.getResource() + "' implements other SAX Visitor interfaces.");
        }
    }

    public Boolean isProvider(List<ContentHandlerBinding<Visitor>> contentHandlerBindings) {
        return contentHandlerBindings.stream().filter(c -> c.getContentHandler() instanceof BeforeVisitor || c.getContentHandler() instanceof AfterVisitor).count() == (long)contentHandlerBindings.size();
    }

    public String getName() {
        return "SAX NG";
    }
}

