/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.sax.TextType;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.api.resource.visitor.sax.ng.ParameterizedVisitor;
import org.smooks.engine.delivery.SmooksContentHandler;
import org.smooks.engine.delivery.event.EndFragmentEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.replay.EndElementEvent;
import org.smooks.engine.delivery.replay.StartElementEvent;
import org.smooks.engine.delivery.sax.ng.CharDataFragmentEvent;
import org.smooks.engine.delivery.sax.ng.ContentHandlerState;
import org.smooks.engine.delivery.sax.ng.SaxNgContentDeliveryConfig;
import org.smooks.engine.delivery.sax.ng.SaxNgVisitorBindings;
import org.smooks.engine.lifecycle.VisitCleanupPhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.memento.TextAccumulatorMemento;
import org.smooks.engine.xml.DocType;
import org.smooks.io.Stream;
import org.smooks.support.DomUtils;
import org.smooks.support.XmlUtil;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SaxNgHandler
extends SmooksContentHandler {
    private final StringBuilder cdataNodeBuilder = new StringBuilder();
    private final ExecutionContext executionContext;
    private final Writer writer;
    private final SaxNgContentDeliveryConfig deliveryConfig;
    private final SaxNgVisitorBindings globalVisitorBindings;
    private final ContentDeliveryRuntime contentDeliveryRuntime;
    private final int globalMaxNodeDepth;
    private final boolean maintainElementStack;
    private final boolean reverseVisitOrderOnVisitAfter;
    private final boolean rewriteEntities;
    private final LifecycleManager lifecycleManager;
    private final StringBuilder entityBuilder = new StringBuilder(10);
    private final DocumentBuilder documentBuilder;
    private ContentHandlerState currentContentHandlerState;
    private NodeFragment currentNodeFragment;
    private Document document;

    public SaxNgHandler(ExecutionContext executionContext, DocumentBuilder documentBuilder) {
        this(executionContext, documentBuilder, null);
    }

    public SaxNgHandler(ExecutionContext executionContext, DocumentBuilder documentBuilder, SmooksContentHandler parentContentHandler) {
        super(executionContext, parentContentHandler);
        this.executionContext = executionContext;
        this.documentBuilder = documentBuilder;
        this.writer = Stream.out(executionContext);
        this.contentDeliveryRuntime = executionContext.getContentDeliveryRuntime();
        this.lifecycleManager = (LifecycleManager)executionContext.getApplicationContext().getRegistry().lookup((Function)new LifecycleManagerLookup());
        this.deliveryConfig = (SaxNgContentDeliveryConfig)this.contentDeliveryRuntime.getContentDeliveryConfig();
        SaxNgVisitorBindings starVisitorBindings = this.deliveryConfig.get("*");
        SaxNgVisitorBindings starStarVisitorBindings = this.deliveryConfig.get("//");
        this.globalVisitorBindings = starVisitorBindings != null ? starVisitorBindings.merge(starStarVisitorBindings) : starStarVisitorBindings;
        this.rewriteEntities = this.deliveryConfig.isRewriteEntities();
        this.maintainElementStack = this.deliveryConfig.isMaintainElementStack();
        this.globalMaxNodeDepth = this.deliveryConfig.getMaxNodeDepth() == 0 ? Integer.MAX_VALUE : this.deliveryConfig.getMaxNodeDepth();
        this.reverseVisitOrderOnVisitAfter = this.deliveryConfig.isReverseVisitOrderOnVisitAfter();
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument() {
        this.document = this.documentBuilder.newDocument();
        this.document.setStrictErrorChecking(false);
        this.currentNodeFragment = null;
        this.currentContentHandlerState = new ContentHandlerState();
    }

    @Override
    public void startElement(StartElementEvent startEvent) {
        boolean isRoot = this.currentContentHandlerState.getPreviousContentHandlerState() == null;
        QName elementQName = XmlUtil.toQName((String)startEvent.uri, (String)startEvent.localName, (String)startEvent.qName);
        String elementName = elementQName != null ? elementQName.getLocalPart() : null;
        SaxNgVisitorBindings visitorBindings = isRoot ? this.deliveryConfig.get("#document", elementName) : this.deliveryConfig.get(elementName);
        if (visitorBindings == null) {
            visitorBindings = this.globalVisitorBindings;
        }
        if (!this.maintainElementStack && visitorBindings == null) {
            ContentHandlerState contentHandlerState = new ContentHandlerState();
            contentHandlerState.setNullProcessor(true);
            contentHandlerState.setPreviousContentHandlerState(this.currentContentHandlerState);
            this.currentContentHandlerState = contentHandlerState;
            StartFragmentEvent<Node> startFragmentEvent = new StartFragmentEvent<Node>(this.currentNodeFragment);
            for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent(startFragmentEvent);
            }
        } else {
            Element element = this.document.createElementNS(elementQName.getNamespaceURI(), elementQName.getPrefix().equals("") ? elementQName.getLocalPart() : elementQName.getPrefix() + ":" + elementQName.getLocalPart());
            for (int i = 0; i < startEvent.attributes.getLength(); ++i) {
                if ("".equals(startEvent.attributes.getURI(i))) {
                    element.setAttribute(startEvent.attributes.getLocalName(i), startEvent.attributes.getValue(i));
                    continue;
                }
                element.setAttributeNS(startEvent.attributes.getURI(i), startEvent.attributes.getQName(i), startEvent.attributes.getValue(i));
            }
            if (isRoot) {
                if (this.document.getFirstChild() != null) {
                    this.document.removeChild(this.document.getFirstChild());
                }
                this.document.appendChild(element);
            } else {
                this.currentNodeFragment.unwrap().appendChild(element);
                this.onChildElement(element);
            }
            this.visitBefore(element, visitorBindings);
        }
    }

    @Override
    public void endElement(EndElementEvent endEvent) throws SAXException {
        Node currentNode;
        boolean isMaxNodeDepth;
        if (!this.contentDeliveryRuntime.getExecutionEventListeners().isEmpty()) {
            EndFragmentEvent endFragmentEvent = new EndFragmentEvent(this.currentNodeFragment);
            for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent((ExecutionEvent)endFragmentEvent);
            }
        }
        boolean bl = isMaxNodeDepth = DomUtils.getDepth(currentNode = this.currentNodeFragment.unwrap()) >= Math.max(this.globalMaxNodeDepth, this.findMaxNodeDepth(this.currentContentHandlerState));
        if (this.currentContentHandlerState.getVisitorBindings() != null) {
            List<ContentHandlerBinding<AfterVisitor>> afterVisitorBindings;
            if (isMaxNodeDepth) {
                TextAccumulatorMemento textAccumulatorMemento = new TextAccumulatorMemento(this.currentNodeFragment);
                this.executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
                currentNode.setTextContent(textAccumulatorMemento.getText());
            }
            if ((afterVisitorBindings = this.currentContentHandlerState.getVisitorBindings().getAfterVisitors()) == null && this.globalVisitorBindings != null) {
                afterVisitorBindings = this.globalVisitorBindings.getAfterVisitors();
            }
            if (afterVisitorBindings != null) {
                if (this.reverseVisitOrderOnVisitAfter) {
                    for (int i = afterVisitorBindings.size() - 1; i >= 0; --i) {
                        this.visitAfter(afterVisitorBindings.get(i));
                    }
                } else {
                    for (ContentHandlerBinding<AfterVisitor> afterVisitorBinding : afterVisitorBindings) {
                        this.visitAfter(afterVisitorBinding);
                    }
                }
            }
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
            List<ContentHandlerBinding<? extends Visitor>> visitorBindings = this.currentContentHandlerState.getVisitorBindings().getAll();
            VisitCleanupPhase visitCleanupPhase = new VisitCleanupPhase(this.currentNodeFragment, this.executionContext);
            for (ContentHandlerBinding<? extends Visitor> visitorBinding : visitorBindings) {
                if (!this.currentNodeFragment.isMatch(visitorBinding.getResourceConfig().getSelectorPath(), this.executionContext)) continue;
                this.lifecycleManager.applyPhase((Object)visitorBinding.getContentHandler(), (LifecyclePhase)visitCleanupPhase);
            }
        }
        this.executionContext.getMementoCaretaker().forget((Fragment)this.currentNodeFragment);
        ContentHandlerState previousContentHandlerState = this.currentContentHandlerState.getPreviousContentHandlerState();
        Node parentNode = currentNode.getParentNode();
        if (isMaxNodeDepth) {
            parentNode.removeChild(currentNode);
        }
        this.currentNodeFragment = new NodeFragment(parentNode);
        this.currentContentHandlerState = previousContentHandlerState;
    }

    protected int findMaxNodeDepth(ContentHandlerState contentHandlerState) {
        int maxNodeDepth = 0;
        for (ContentHandlerState previousNodeState = contentHandlerState; previousNodeState != null; previousNodeState = previousNodeState.getPreviousContentHandlerState()) {
            maxNodeDepth = Math.max(previousNodeState.getMaxDepth(), maxNodeDepth);
        }
        return maxNodeDepth;
    }

    protected void visitBefore(Element element, SaxNgVisitorBindings saxNgVisitorBindings) {
        this.currentNodeFragment = new NodeFragment(element);
        ContentHandlerState contentHandlerState = new ContentHandlerState();
        contentHandlerState.setPreviousContentHandlerState(this.currentContentHandlerState);
        contentHandlerState.setVisitorBindings(saxNgVisitorBindings);
        this.currentContentHandlerState = contentHandlerState;
        if (this.currentContentHandlerState.getVisitorBindings() != null) {
            List<ContentHandlerBinding<BeforeVisitor>> visitBeforeBindings = this.currentContentHandlerState.getVisitorBindings().getBeforeVisitors();
            if (visitBeforeBindings == null && this.globalVisitorBindings != null) {
                visitBeforeBindings = this.globalVisitorBindings.getBeforeVisitors();
            }
            if (visitBeforeBindings != null) {
                int maxNodeDepth = 1;
                for (ContentHandlerBinding<BeforeVisitor> visitBeforeBinding : visitBeforeBindings) {
                    if (!this.currentNodeFragment.isMatch(visitBeforeBinding.getResourceConfig().getSelectorPath(), this.executionContext)) continue;
                    if (visitBeforeBinding.getContentHandler() instanceof ParameterizedVisitor) {
                        maxNodeDepth = Math.max(maxNodeDepth, ((ParameterizedVisitor)visitBeforeBinding.getContentHandler()).getMaxNodeDepth());
                    }
                    ((BeforeVisitor)visitBeforeBinding.getContentHandler()).visitBefore(element, this.executionContext);
                }
                this.currentContentHandlerState.setMaxDepth(maxNodeDepth);
            }
        }
        if (!this.contentDeliveryRuntime.getExecutionEventListeners().isEmpty()) {
            StartFragmentEvent<Node> startFragmentEvent = new StartFragmentEvent<Node>(this.currentNodeFragment);
            for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent(startFragmentEvent);
            }
        }
    }

    protected void onChildElement(Element childElement) {
        if (this.currentContentHandlerState.getVisitorBindings() != null) {
            List<ContentHandlerBinding<ChildrenVisitor>> childVisitorBindings = this.currentContentHandlerState.getVisitorBindings().getChildVisitors();
            if (childVisitorBindings == null && this.globalVisitorBindings != null) {
                childVisitorBindings = this.globalVisitorBindings.getChildVisitors();
            }
            if (childVisitorBindings != null) {
                for (ContentHandlerBinding<ChildrenVisitor> contentHandlerBinding : childVisitorBindings) {
                    if (!this.currentNodeFragment.isMatch(contentHandlerBinding.getResourceConfig().getSelectorPath(), this.executionContext)) continue;
                    ((ChildrenVisitor)contentHandlerBinding.getContentHandler()).visitChildElement(childElement, this.executionContext);
                }
            }
        }
    }

    protected void visitAfter(ContentHandlerBinding<AfterVisitor> afterVisitorBinding) {
        if (this.currentNodeFragment.isMatch(afterVisitorBinding.getResourceConfig().getSelectorPath(), this.executionContext)) {
            ((AfterVisitor)afterVisitorBinding.getContentHandler()).visitAfter((Element)this.currentNodeFragment.unwrap(), this.executionContext);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentContentHandlerState.getTextType() != TextType.CDATA) {
            this.doCharacters(ch, start, length);
        } else {
            this.cdataNodeBuilder.append(ch, start, length);
        }
    }

    protected void doCharacters(char[] ch, int start, int length) {
        if (!this.rewriteEntities && this.currentContentHandlerState.getTextType() == TextType.ENTITY) {
            this.entityBuilder.setLength(0);
            this.entityBuilder.append("&#").append((int)ch[start]).append(';');
            this.entityBuilder.getChars(0, this.entityBuilder.length(), new char[this.entityBuilder.length()], 0);
        }
        if (this.currentNodeFragment != null) {
            List<ContentHandlerBinding<ChildrenVisitor>> childVisitorBindings;
            CharacterData characterData;
            switch (this.currentContentHandlerState.getTextType()) {
                case CDATA: {
                    characterData = this.document.createCDATASection(new String(ch, start, length));
                    break;
                }
                case COMMENT: {
                    characterData = this.document.createComment(new String(ch, start, length));
                    break;
                }
                case ENTITY: {
                    if (!this.rewriteEntities) {
                        this.entityBuilder.setLength(0);
                        this.entityBuilder.append("&#").append((int)ch[start]).append(';');
                        char[] newBuf = new char[this.entityBuilder.length()];
                        this.entityBuilder.getChars(0, newBuf.length, newBuf, 0);
                        characterData = this.document.createTextNode(new String(newBuf, 0, newBuf.length));
                        break;
                    }
                }
                default: {
                    characterData = this.document.createTextNode(new String(ch, start, length));
                }
            }
            Node currentNode = this.currentNodeFragment.unwrap();
            currentNode.appendChild(characterData);
            if (!this.currentContentHandlerState.isNullProcessor() && this.currentContentHandlerState.getVisitorBindings() != null && (childVisitorBindings = this.currentContentHandlerState.getVisitorBindings().getChildVisitors()) != null) {
                for (ContentHandlerBinding<ChildrenVisitor> childrenVisitorBinding : childVisitorBindings) {
                    if (!this.currentNodeFragment.isMatch(childrenVisitorBinding.getResourceConfig().getSelectorPath(), this.executionContext)) continue;
                    ((ChildrenVisitor)childrenVisitorBinding.getContentHandler()).visitChildText(characterData, this.executionContext);
                }
            }
            if (!this.contentDeliveryRuntime.getExecutionEventListeners().isEmpty()) {
                CharDataFragmentEvent charFragmentEvent = new CharDataFragmentEvent(new NodeFragment(characterData));
                for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent((ExecutionEvent)charFragmentEvent);
                }
            }
            if (DomUtils.getDepth(currentNode) + 1 >= Math.max(this.globalMaxNodeDepth, this.findMaxNodeDepth(this.currentContentHandlerState))) {
                currentNode.removeChild(characterData);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.currentContentHandlerState.setTextType(TextType.COMMENT);
        this.characters(ch, start, length);
        this.currentContentHandlerState.setTextType(TextType.TEXT);
    }

    @Override
    public void startCDATA() {
        this.currentContentHandlerState.setTextType(TextType.CDATA);
        this.cdataNodeBuilder.setLength(0);
    }

    @Override
    public void endCDATA() {
        try {
            char[] chars = new char[this.cdataNodeBuilder.length()];
            this.cdataNodeBuilder.getChars(0, chars.length, chars, 0);
            this.doCharacters(chars, 0, chars.length);
            this.currentContentHandlerState.setTextType(TextType.TEXT);
        }
        finally {
            this.cdataNodeBuilder.setLength(0);
        }
    }

    @Override
    public void startEntity(String name) {
        this.currentContentHandlerState.setTextType(TextType.ENTITY);
    }

    @Override
    public void endEntity(String name) {
        this.currentContentHandlerState.setTextType(TextType.TEXT);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocType.DocumentTypeData docTypeData;
        DocType.setDocType(name, publicId, systemId, null, this.executionContext);
        if (this.writer != null && (docTypeData = DocType.getDocType(this.executionContext)) != null) {
            try {
                DocType.serializeDoctype(docTypeData, this.writer);
            }
            catch (IOException e) {
                throw new SAXException("Failed to serialize DOCTYPE.");
            }
        }
    }
}

