/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.session;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Session {
    private final Node node;

    public Session(Node node) {
        if (!Session.isSession(node)) {
            throw new SmooksException("Node is not a Smooks session");
        }
        this.node = node;
    }

    public static boolean isSession(Node node) {
        return node instanceof Element && node.getNamespaceURI() != null && node.getNamespaceURI().equals("https://www.smooks.org") && node.getLocalName().equals("session");
    }

    public TypedKey<Node> getSourceKey() {
        return new TypedKey(this.node.getAttributes().getNamedItem("source").getNodeValue());
    }

    public String getVisit() {
        return this.node.getAttributes().getNamedItem("visit").getNodeValue();
    }

    public Node getSourceValue(ExecutionContext executionContext) {
        return (Node)executionContext.get(new TypedKey(this.node.getAttributes().getNamedItem("source").getNodeValue()));
    }
}

