/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.support.ClassUtil;

public abstract class AbstractLifecyclePhase
implements LifecyclePhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLifecyclePhase.class);

    public void apply(Object o) {
        this.doApply(o);
    }

    public void doApply(Object o) {
    }

    protected <U> void invoke(U instance, Class<? extends Annotation> annotation) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            if (method.getParameterTypes().length == 0) {
                try {
                    method.invoke(instance, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new SmooksConfigException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new SmooksConfigException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", e.getTargetException());
                }
            }
            LOGGER.warn("Method '" + ClassUtil.getLongMemberName((Member)method) + "' defines an @" + annotation.getSimpleName() + " annotation on a paramaterized method.  This is not allowed!");
        }
    }
}

