/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.lifecycle;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.resource.config.Configurable;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.injector.FieldInjector;
import org.smooks.engine.injector.MethodInjector;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.AbstractLifecyclePhase;
import org.smooks.support.ClassUtil;

public class PostConstructLifecyclePhase
extends AbstractLifecyclePhase {
    private final Scope scope;

    public PostConstructLifecyclePhase(Scope scope) {
        AssertArgument.isNotNull((Object)scope, (String)"scope");
        this.scope = scope;
    }

    public PostConstructLifecyclePhase() {
        this.scope = null;
    }

    @Override
    public void doApply(Object o) {
        if (this.scope != null) {
            FieldInjector fieldInjector = new FieldInjector(o, this.scope);
            fieldInjector.inject();
            MethodInjector methodInjector = new MethodInjector(o, this.scope);
            methodInjector.inject();
            this.setConfiguration(o, this.scope);
        }
        this.checkPropertiesConfigured(o.getClass(), o);
        this.invoke(o, PostConstruct.class);
    }

    protected <U> void checkPropertiesConfigured(Class contentHandlerClass, U instance) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null) {
            this.checkPropertiesConfigured(superClass, instance);
        }
        for (Field field : fields) {
            String setterName;
            Method setterMethod;
            Object fieldValue;
            String fieldName = field.getName();
            try {
                fieldValue = ClassUtil.getField((Field)field, instance);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigException("Unable to get property field value for '" + ClassUtil.getLongMemberName((Member)field) + "'.", (Throwable)e);
            }
            if (fieldValue != null) continue;
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null && (setterMethod = ClassUtil.getSetterMethod((String)(setterName = ClassUtil.toSetterName((String)fieldName)), (Class)contentHandlerClass, field.getType())) != null) {
                injectAnnotation = setterMethod.getAnnotation(Inject.class);
            }
            if (injectAnnotation == null) continue;
            throw new SmooksConfigException("Property '" + fieldName + "' not configured on class " + instance.getClass().getName() + "'.");
        }
    }

    private <U> void setConfiguration(U instance, Scope scope) {
        if (instance instanceof Configurable) {
            ((Configurable)instance).setConfiguration(((ResourceConfig)scope.get(ResourceConfig.class)).toProperties());
        } else {
            try {
                Method setConfigurationMethod = instance.getClass().getMethod("setConfiguration", ResourceConfig.class);
                setConfigurationMethod.invoke(instance, scope.get(ResourceConfig.class));
            }
            catch (NoSuchMethodException setConfigurationMethod) {
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.  This class must be public.  Alternatively, use the @Inject annotation on a class field.", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SmooksConfigException) {
                    throw (SmooksConfigException)e.getTargetException();
                }
                Throwable cause = e.getTargetException();
                throw new SmooksConfigException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.", cause != null ? cause : e);
            }
        }
    }
}

