/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.memento;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.smooks.api.TypedKey;
import org.smooks.api.TypedMap;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.memento.Memento;
import org.smooks.api.memento.MementoCaretaker;

@NotThreadSafe
public class DefaultMementoCaretaker
implements MementoCaretaker {
    private final Map<Fragment<?>, Set<String>> mementoAnchors = new HashMap();
    private final TypedMap typedMap;

    public DefaultMementoCaretaker(TypedMap typedMap) {
        this.typedMap = typedMap;
    }

    public void capture(Memento memento) {
        this.mementoAnchors.computeIfAbsent(memento.getFragment(), o -> new HashSet()).add(memento.getAnchor());
        this.typedMap.put(new TypedKey(memento.getAnchor()), (Object)memento.copy());
    }

    public void restore(Memento memento) {
        Memento restoredMemento = (Memento)this.typedMap.get(new TypedKey(memento.getAnchor()));
        if (restoredMemento != null) {
            memento.restore(restoredMemento);
        }
    }

    public boolean exists(Memento memento) {
        return this.typedMap.get(new TypedKey(memento.getAnchor())) != null;
    }

    public void forget(Memento visitorMemento) {
        this.typedMap.remove(new TypedKey(visitorMemento.getAnchor()));
        ((Set)this.mementoAnchors.getOrDefault(visitorMemento.getFragment(), new HashSet())).remove(visitorMemento.getAnchor());
    }

    public void forget(Fragment<?> fragment) {
        for (String anchor : (Set)this.mementoAnchors.getOrDefault(fragment, new HashSet())) {
            this.typedMap.remove(new TypedKey(anchor));
        }
        this.mementoAnchors.remove(fragment);
    }

    public <T extends Memento> T stash(T defaultMemento, Function<T, T> function) {
        this.restore(defaultMemento);
        Memento newVisitorMemento = (Memento)function.apply(defaultMemento);
        this.capture(newVisitorMemento);
        return (T)newVisitorMemento;
    }
}

