/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.plugin;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.smooks.Smooks;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.plugin.ResultFactory;
import org.smooks.engine.plugin.ResultType;
import org.smooks.engine.plugin.SourceFactory;
import org.smooks.engine.plugin.SourceResult;
import org.smooks.io.payload.ByteResult;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.StringResult;

public class PayloadProcessor {
    private final Smooks smooks;
    private final ResultType resultType;
    private String javaResultBeanId;

    public PayloadProcessor(Smooks smooks, ResultType resultType) {
        AssertArgument.isNotNull((Object)smooks, (String)"smooks");
        AssertArgument.isNotNull((Object)((Object)resultType), (String)"resultType");
        this.smooks = smooks;
        this.resultType = resultType;
    }

    public void setJavaResultBeanId(String javaResultBeanId) {
        AssertArgument.isNotNullAndNotEmpty((String)javaResultBeanId, (String)"javaResultBeanId");
        this.javaResultBeanId = javaResultBeanId;
    }

    public final Object process(Object payload, ExecutionContext executionContext) throws SmooksException {
        Result result;
        Source source;
        AssertArgument.isNotNull((Object)payload, (String)"payload");
        if (payload instanceof SourceResult) {
            SourceResult sourceResult = (SourceResult)payload;
            source = sourceResult.getSource();
            result = sourceResult.getResult();
        } else {
            source = SourceFactory.getInstance().createSource(payload);
            result = ResultFactory.getInstance().createResult(this.resultType);
        }
        this.smooks.filterSource(executionContext, source, result);
        if (result instanceof JavaResult) {
            if (this.javaResultBeanId != null) {
                return ((JavaResult)result).getResultMap().get(this.javaResultBeanId);
            }
            return ((JavaResult)result).getResultMap();
        }
        if (result instanceof StringResult) {
            return ((StringResult)result).getResult();
        }
        if (result instanceof ByteResult) {
            return ((ByteResult)result).getResult();
        }
        return result;
    }
}

