/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Result;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ConfigBuilderEvent;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ResourceBasedEvent;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.event.BasicExecutionEventListener;
import org.smooks.engine.delivery.event.DOMFilterLifecycleEvent;
import org.smooks.engine.delivery.event.FilterLifecycleEvent;
import org.smooks.engine.delivery.event.FragmentEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.event.VisitEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.report.ReportConfiguration;
import org.smooks.engine.report.model.DOMReport;
import org.smooks.engine.report.model.MessageNode;
import org.smooks.engine.report.model.Report;
import org.smooks.engine.report.model.ReportInfoNode;
import org.smooks.engine.report.model.ResultNode;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.StringResult;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractReportGenerator
extends BasicExecutionEventListener {
    private final ReportConfiguration reportConfiguration;
    private Report report;
    private ExecutionContext executionContext;
    private int messageNodeCounter;
    private int reportInfoNodeCounter;
    private final List<ExecutionEvent> preProcessingEvents = new ArrayList<ExecutionEvent>();
    private final List<ExecutionEvent> processingEvents = new ArrayList<ExecutionEvent>();
    private final Stack<ReportNode> reportNodeStack = new Stack();
    private final List<ReportNode> allNodes = new ArrayList<ReportNode>();

    protected AbstractReportGenerator(ReportConfiguration reportConfiguration) {
        AssertArgument.isNotNull((Object)reportConfiguration, (String)"reportConfiguration");
        this.reportConfiguration = reportConfiguration;
        this.setFilterEvents(reportConfiguration.getFilterEvents());
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Writer getOutputWriter() {
        return this.reportConfiguration.getOutputWriter();
    }

    @Override
    public void onEvent(ExecutionEvent executionEvent) {
        AssertArgument.isNotNull((Object)executionEvent, (String)"executionEvent");
        if (this.ignoreEvent(executionEvent)) {
            return;
        }
        if (executionEvent instanceof FilterLifecycleEvent) {
            this.processLifecycleEvent((FilterLifecycleEvent)executionEvent);
        } else if (executionEvent instanceof StartFragmentEvent) {
            ReportNode node = new ReportNode((StartFragmentEvent)executionEvent);
            this.allNodes.add(node);
            this.processNewElementEvent(node);
        } else if (this.reportNodeStack.isEmpty()) {
            this.preProcessingEvents.add(executionEvent);
        } else if (executionEvent instanceof FragmentEvent) {
            ReportNode reportNode = this.getReportNode(((FragmentEvent)executionEvent).getFragment().unwrap());
            if (reportNode != null) {
                reportNode.elementProcessingEvents.add(executionEvent);
            }
        } else {
            this.processingEvents.add(executionEvent);
        }
    }

    @Override
    protected boolean ignoreEvent(ExecutionEvent event) {
        if (!super.ignoreEvent(event)) {
            if (event instanceof ResourceBasedEvent && !this.reportConfiguration.showDefaultAppliedResources()) {
                return ((ResourceBasedEvent)event).getResourceConfig().isDefaultResource();
            }
            return false;
        }
        return true;
    }

    private void processLifecycleEvent(FilterLifecycleEvent event) {
        try {
            if (event.getEventType() != FilterLifecycleEvent.EventType.FINISHED) {
                ContentDeliveryConfig deliveryConfig = event.getExecutionContext().getContentDeliveryRuntime().getContentDeliveryConfig();
                if (event instanceof DOMFilterLifecycleEvent) {
                    DOMFilterLifecycleEvent domEvent = (DOMFilterLifecycleEvent)event;
                    if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.PROCESSING_STARTED) {
                        this.mapMessageNodeVists(((DOMReport)this.report).getAssemblies());
                    } else if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.SERIALIZATION_STARTED) {
                        this.mapMessageNodeVists(this.report.getProcessings());
                    }
                } else if (event.getEventType() == FilterLifecycleEvent.EventType.STARTED) {
                    this.executionContext = event.getExecutionContext();
                    this.report = deliveryConfig instanceof DOMContentDeliveryConfig ? new DOMReport() : new Report();
                    this.mapConfigBuilderEvents(deliveryConfig.getConfigBuilderEvents());
                }
            } else {
                this.processFinishEvent();
            }
        }
        catch (IOException e) {
            throw new SmooksException("Failed to write report.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishEvent() throws IOException {
        if (this.report instanceof DOMReport) {
            if (this.report.getProcessings().isEmpty()) {
                this.mapMessageNodeVists(this.report.getProcessings());
            } else {
                this.mapMessageNodeVists(((DOMReport)this.report).getSerializations());
            }
        } else {
            this.mapMessageNodeVists(this.report.getProcessings());
        }
        ArrayList<ResultNode> resultNodes = new ArrayList<ResultNode>();
        Result[] results = FilterResult.getResults(this.executionContext);
        this.report.setResults(resultNodes);
        if (results != null) {
            for (Result result : results) {
                if (result == null) continue;
                ResultNode resultNode = new ResultNode();
                resultNodes.add(resultNode);
                if (result instanceof JavaResult) {
                    resultNode.setSummary("This Smooks Filtering operation produced a JavaResult.  The following is an XML serialization of the JavaResult bean Map entries.");
                } else if (result instanceof StringResult) {
                    resultNode.setSummary("This Smooks Filtering operation produced the following StreamResult.");
                } else {
                    resultNode.setSummary("Cannot show Smooks Filtering Result.  Modify the code and use a '" + StringResult.class.getName() + "' Result in the call to the Smooks.filter() method.");
                }
                resultNode.setDetail(result.toString());
            }
        }
        try {
            this.applyTemplate(this.report);
        }
        finally {
            Writer writer = this.reportConfiguration.getOutputWriter();
            try {
                writer.flush();
            }
            finally {
                if (this.reportConfiguration.autoCloseWriter()) {
                    writer.close();
                }
            }
        }
    }

    private void processNewElementEvent(ReportNode node) {
        if (this.reportNodeStack.isEmpty()) {
            this.reportNodeStack.push(node);
        } else {
            ReportNode head = this.reportNodeStack.peek();
            while (head != null && node.depth <= head.depth) {
                this.reportNodeStack.pop();
                if (!this.reportNodeStack.isEmpty()) {
                    head = this.reportNodeStack.peek();
                    continue;
                }
                head = null;
            }
            node.parent = head;
            if (node.parent != null) {
                node.parent.children.add(node);
            }
            this.reportNodeStack.push(node);
        }
    }

    private void mapConfigBuilderEvents(List<ConfigBuilderEvent> configBuilderEvents) {
    }

    private void mapMessageNodeVists(List<MessageNode> visits) throws IOException {
        if (!this.allNodes.isEmpty()) {
            this.mapNode((ReportNode)this.reportNodeStack.elementAt(0), visits);
        }
        this.preProcessingEvents.clear();
        this.processingEvents.clear();
        this.reportNodeStack.clear();
        this.allNodes.clear();
    }

    private void mapNode(ReportNode reportNode, List<MessageNode> visits) throws IOException {
        MessageNode messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(true);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.BEFORE, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
        List children = reportNode.children;
        for (ReportNode child : children) {
            this.mapNode(child, visits);
        }
        messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(false);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.AFTER, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
    }

    private void mapNodeEvents(VisitSequence visitSequence, ReportNode reportNode, MessageNode messageNode) {
        List<ExecutionEvent> events = reportNode.getElementProcessingEvents();
        for (ExecutionEvent event : events) {
            VisitEvent visitEvent;
            if (!(event instanceof VisitEvent) || (visitEvent = (VisitEvent)event).getSequence() != visitSequence) continue;
            ReportInfoNode reportInfoNode = new ReportInfoNode();
            ContentHandlerBinding configMapping = ((VisitEvent)event).getVisitorBinding();
            messageNode.addExecInfoNode(reportInfoNode);
            reportInfoNode.setNodeId(this.reportInfoNodeCounter);
            reportInfoNode.setSummary(configMapping.getContentHandler().getClass().getSimpleName() + ": " + visitEvent.getReportSummary());
            reportInfoNode.setDetail(visitEvent.getReportDetail());
            reportInfoNode.setResourceXML(configMapping.getResourceConfig().toXml());
            reportInfoNode.setContextState(visitEvent.getExecutionContextState());
            ++this.reportInfoNodeCounter;
        }
    }

    public abstract void applyTemplate(Report var1) throws IOException;

    private ReportNode getReportNode(Object element) {
        for (ReportNode node : this.allNodes) {
            if (node.element != element) continue;
            return node;
        }
        return null;
    }

    public class ReportNode {
        private ReportNode parent;
        private final List<ReportNode> children = new ArrayList<ReportNode>();
        private final Object element;
        private final int depth;
        private final List<ExecutionEvent> elementProcessingEvents = new ArrayList<ExecutionEvent>();

        public ReportNode(StartFragmentEvent eventPresentEvent) {
            this.element = eventPresentEvent.getFragment().unwrap();
            this.depth = eventPresentEvent.getDepth();
        }

        public String getElementName() {
            return DomUtils.getName((Element)this.element);
        }

        public String toString() {
            return this.element + " (depth " + this.depth + ")";
        }

        public ReportNode getParent() {
            return this.parent;
        }

        public List<ReportNode> getChildren() {
            return this.children;
        }

        public Object getElement() {
            return this.element;
        }

        public int getDepth() {
            return this.depth;
        }

        public List<ExecutionEvent> getElementProcessingEvents() {
            return this.elementProcessingEvents;
        }
    }
}

