/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.report;

import freemarker.template.utility.HtmlEscape;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import org.smooks.engine.report.AbstractReportGenerator;
import org.smooks.engine.report.ReportConfiguration;
import org.smooks.engine.report.model.DOMReport;
import org.smooks.engine.report.model.Report;
import org.smooks.support.FreeMarkerTemplate;

public class HtmlReportGenerator
extends AbstractReportGenerator {
    public HtmlReportGenerator(Writer outputWriter) {
        this(new ReportConfiguration(outputWriter));
    }

    public HtmlReportGenerator(String outputFile) throws IOException {
        super(new ReportConfiguration(HtmlReportGenerator.createOutputWriter(outputFile)));
        File file = new File(outputFile);
        if (file.getParentFile() != null) {
            this.getReportConfiguration().setTempOutDir(file.getParentFile());
        }
    }

    protected HtmlReportGenerator(ReportConfiguration reportConfiguration) {
        super(reportConfiguration);
    }

    @Override
    public void applyTemplate(Report report) throws IOException {
        System.out.println();
        System.out.println("****************************************************************************************");
        System.out.println("  HTML REPORT GENERATOR IN USE!!!");
        System.out.println("  Please disable in Production mode.  This feature is a major performance drain!!");
        System.out.println("****************************************************************************************");
        System.out.println();
        FreeMarkerTemplate template = report instanceof DOMReport ? new FreeMarkerTemplate("html/template-dom.html", HtmlReportGenerator.class) : new FreeMarkerTemplate("html/template-sax.html", HtmlReportGenerator.class);
        Writer writer = this.getReportConfiguration().getOutputWriter();
        HashMap<String, Report> templateModel = new HashMap<String, Report>();
        templateModel.put("report", report);
        templateModel.put("htmlEscape", (Report)new HtmlEscape());
        writer.write(template.apply(templateModel));
    }

    private static Writer createOutputWriter(String outputFile) throws IOException {
        File file = new File(outputFile);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return Files.newBufferedWriter(Paths.get(file.toURI()), new OpenOption[0]);
    }
}

