/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.List;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ParameterDecodeException;
import org.smooks.engine.resource.config.ParameterDecoder;
import org.w3c.dom.Element;

public class DefaultParameter<T>
implements Parameter<T> {
    private final String name;
    private String type;
    private final T value;
    private Element xml;

    public DefaultParameter(String name, T value) {
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in constructor call.");
        }
        if (value == null) {
            throw new IllegalArgumentException("null 'value' arg in constructor call.");
        }
        this.name = name;
        this.value = value;
    }

    public DefaultParameter(String name, T value, String type) {
        this(name, value);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public Object getValue(ContentDeliveryConfig deliveryConfig) throws ParameterDecodeException {
        if (this.type != null && this.value != null) {
            List decoders = deliveryConfig.getObjects("param-type:" + this.type);
            if (!decoders.isEmpty()) {
                try {
                    ParameterDecoder paramDecoder = (ParameterDecoder)decoders.get(0);
                    return paramDecoder.decodeValue(this.value);
                }
                catch (ClassCastException cast) {
                    throw new ParameterDecodeException("Configured ParameterDecoder 'param-type:" + this.type + "' for device must be of type " + ParameterDecoder.class);
                }
            }
            throw new ParameterDecodeException("ParameterDecoder 'param-type:" + this.type + "' not defined for requesting device.");
        }
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public Parameter<T> setXml(Element xml) {
        this.xml = xml;
        return this;
    }

    public Element getXml() {
        return this.xml;
    }
}

