/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.profile.Profile;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ProfileTargetingExpression;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigChangeListener;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.classpath.ClasspathUtils;
import org.smooks.engine.resource.config.DefaultParameter;
import org.smooks.engine.resource.config.DefaultProfileTargetingExpression;
import org.smooks.engine.resource.config.xpath.SelectorPathFactory;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.ClassUtil;
import org.smooks.support.StreamUtils;
import org.smooks.support.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultResourceConfig
implements ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceConfig.class);
    private static final URIResourceLocator uriResourceLocator = new URIResourceLocator();
    private SelectorPath selectorPath;
    private String targetProfile;
    private String[] profileTargetingExpressionStrings;
    private ProfileTargetingExpression[] profileTargetingExpressions;
    private String resource;
    private boolean isInline;
    private String resourceType;
    private LinkedHashMap<String, Object> parameters = new LinkedHashMap();
    private int parameterCount;
    private boolean defaultResource;
    @Deprecated
    private String extendedConfigNS;
    private final Set<ResourceConfigChangeListener> changeListeners = new HashSet<ResourceConfigChangeListener>();

    public DefaultResourceConfig() {
        this.setSelector("none", new Properties());
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public DefaultResourceConfig(String selector, Properties namespaces) {
        this.setSelector(selector, namespaces);
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public DefaultResourceConfig(ResourceConfig resourceConfig) {
        this.setTargetProfile(resourceConfig.getTargetProfile());
        this.setResource(resourceConfig.getResource());
        this.setSelectorPath(SelectorPathFactory.newSelectorPath(resourceConfig.getSelectorPath()));
        this.setDefaultResource(resourceConfig.isDefaultResource());
    }

    public DefaultResourceConfig(String selector, Properties namespaces, String resource) {
        this(selector, namespaces, Profile.DEFAULT_PROFILE, resource);
    }

    public DefaultResourceConfig(String selector, Properties namespaces, String targetProfile, String resource) {
        this(selector, namespaces);
        this.setTargetProfile(targetProfile);
        this.setResource(resource);
    }

    public ResourceConfig copy() {
        DefaultResourceConfig copyResourceConfig = new DefaultResourceConfig();
        copyResourceConfig.extendedConfigNS = this.extendedConfigNS;
        copyResourceConfig.selectorPath = SelectorPathFactory.newSelectorPath(this.selectorPath);
        copyResourceConfig.targetProfile = this.targetProfile;
        copyResourceConfig.defaultResource = this.defaultResource;
        copyResourceConfig.profileTargetingExpressionStrings = this.profileTargetingExpressionStrings;
        copyResourceConfig.profileTargetingExpressions = this.profileTargetingExpressions;
        copyResourceConfig.resource = this.resource;
        copyResourceConfig.isInline = this.isInline;
        copyResourceConfig.resourceType = this.resourceType;
        if (this.parameters != null) {
            copyResourceConfig.parameters = (LinkedHashMap)this.parameters.clone();
        }
        copyResourceConfig.parameterCount = this.parameterCount;
        return copyResourceConfig;
    }

    @Deprecated
    public String getExtendedConfigNS() {
        return this.extendedConfigNS;
    }

    @Deprecated
    public void setExtendedConfigNS(String extendedConfigNS) {
        this.extendedConfigNS = extendedConfigNS;
    }

    public void addParameters(ResourceConfig resourceConfig) {
        this.parameters.putAll(resourceConfig.getParameters());
    }

    public DefaultResourceConfig(String selector, Properties namespaces, @Deprecated String selectorNamespaceURI, String targetProfile, String resource) {
        this(selector, namespaces, targetProfile, resource);
        this.selectorPath.setSelectorNamespaceURI(selectorNamespaceURI);
    }

    public void setSelector(String selector, Properties namespaces) {
        if (selector != null) {
            if (this.selectorPath == null) {
                this.selectorPath = SelectorPathFactory.newSelectorPath(selector, namespaces);
            } else {
                this.selectorPath = SelectorPathFactory.newSelectorPath(selector, this.selectorPath);
                this.selectorPath.getNamespaces().putAll((Map<?, ?>)namespaces);
            }
        } else {
            this.selectorPath = SelectorPathFactory.newSelectorPath("none", namespaces);
        }
        this.fireChangedEvent();
    }

    public void setResource(String resource) {
        this.resource = resource;
        if (resource != null) {
            try {
                new URI(resource);
                this.isInline = false;
            }
            catch (Exception e) {
                this.isInline = true;
            }
        }
        this.fireChangedEvent();
    }

    public boolean isInline() {
        return this.isInline;
    }

    public String getTargetProfile() {
        return this.targetProfile;
    }

    public void setTargetProfile(String targetProfile) {
        if (targetProfile == null || targetProfile.trim().equals("")) {
            targetProfile = Profile.DEFAULT_PROFILE;
        }
        this.targetProfile = targetProfile;
        this.parseTargetingExpressions(targetProfile);
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setSelectorPath(SelectorPath selectorPath) {
        this.selectorPath = selectorPath;
        this.fireChangedEvent();
    }

    public SelectorPath getSelectorPath() {
        return this.selectorPath;
    }

    public ProfileTargetingExpression[] getProfileTargetingExpressions() {
        return this.profileTargetingExpressions;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isDefaultResource() {
        return this.defaultResource;
    }

    public void setDefaultResource(boolean defaultResource) {
        this.defaultResource = defaultResource;
    }

    public String getResourceType() {
        if (this.isJavaResource()) {
            return "class";
        }
        String restype = this.resourceType != null ? this.resourceType : this.getExtension(this.getResource());
        return restype;
    }

    private void parseTargetingExpressions(String targetProfiles) {
        StringTokenizer tokenizer = new StringTokenizer(targetProfiles, ",|;");
        if (tokenizer.countTokens() == 0) {
            throw new IllegalArgumentException("Empty 'target-profile'. [" + this.selectorPath.getSelector() + "][" + this.resource + "]");
        }
        this.profileTargetingExpressionStrings = new String[tokenizer.countTokens()];
        this.profileTargetingExpressions = new DefaultProfileTargetingExpression[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String expression;
            this.profileTargetingExpressionStrings[i] = expression = tokenizer.nextToken();
            this.profileTargetingExpressions[i] = new DefaultProfileTargetingExpression(expression);
            ++i;
        }
    }

    private String getExtension(String path) {
        int extensionIndex;
        File resFile;
        String resName;
        if (path != null && !(resName = (resFile = new File(path)).getName()).trim().equals("") && (extensionIndex = resName.lastIndexOf(46)) != -1 && extensionIndex + 1 < resName.length()) {
            return resName.substring(extensionIndex + 1);
        }
        return null;
    }

    public <T> Parameter<T> setParameter(String name, T value) {
        DefaultParameter<T> param = new DefaultParameter<T>(name, value);
        this.setParameter(param);
        return param;
    }

    public <T> Parameter<T> setParameter(String name, String type, T value) {
        DefaultParameter<T> param = new DefaultParameter<T>(name, value, type);
        this.setParameter(param);
        return param;
    }

    public <T> void setParameter(Parameter<T> parameter) {
        Object exists;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        if ((exists = this.parameters.get(parameter.getName())) == null) {
            this.parameters.put(parameter.getName(), parameter);
        } else if (exists instanceof Parameter) {
            Vector<Object> paramList = new Vector<Object>();
            paramList.add((Parameter)exists);
            paramList.add(parameter);
            this.parameters.put(parameter.getName(), paramList);
        } else if (exists instanceof List) {
            ((List)exists).add(parameter);
        }
        ++this.parameterCount;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> valueClass) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (Parameter)((List)parameter).get(0);
        }
        if (parameter instanceof Parameter) {
            return (Parameter)parameter;
        }
        return null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List<?> getParameterValues() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.parameters.values());
    }

    public List<Parameter<?>> getParameters(String name) {
        if (this.parameters != null) {
            Object parameter = this.parameters.get(name);
            if (parameter instanceof List) {
                return (List)parameter;
            }
            if (parameter instanceof Parameter) {
                ArrayList paramList = new ArrayList();
                paramList.add((Parameter)parameter);
                return paramList;
            }
        }
        return Collections.emptyList();
    }

    public Object getParameterValue(String name) {
        Parameter<Object> parameter = this.getParameter(name, Object.class);
        return parameter != null ? parameter.getValue() : null;
    }

    public <T> T getParameterValue(String name, Class<T> valueClass) {
        Parameter<T> parameter = this.getParameter(name, valueClass);
        return (T)(parameter != null ? parameter.getValue() : null);
    }

    public <T> T getParameterValue(String name, Class<T> valueClass, T defaultValue) {
        T value = this.getParameterValue(name, valueClass);
        return value != null ? value : defaultValue;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public boolean isXmlDef() {
        return this.selectorPath.getSelector().startsWith("xmldef:");
    }

    public String toString() {
        return "Target Profile: [" + Arrays.asList(this.profileTargetingExpressionStrings) + "], Selector: [" + this.selectorPath.getSelector() + "], Selector Namespace URI: [" + this.selectorPath.getSelectorNamespaceURI() + "], Resource: [" + this.resource + "], Num Params: [" + this.getParameterCount() + "]";
    }

    public byte[] getBytes() {
        if (this.resource != null) {
            InputStream resStream;
            try {
                resStream = uriResourceLocator.getResource(this.resource);
            }
            catch (Exception e) {
                return this.getInlineResourceBytes();
            }
            try {
                byte[] resourceBytes;
                if (resStream == null) {
                    throw new IOException("Resource [" + this.resource + "] not found.");
                }
                try {
                    resourceBytes = StreamUtils.readStream((InputStream)resStream);
                }
                finally {
                    resStream.close();
                }
                return resourceBytes;
            }
            catch (IOException e) {
                return this.getInlineResourceBytes();
            }
        }
        return null;
    }

    private byte[] getInlineResourceBytes() {
        return this.resource.getBytes(StandardCharsets.UTF_8);
    }

    protected Class<?> toJavaResource() {
        if (this.resource == null || this.resource.trim().length() < 1) {
            return null;
        }
        String className = ClasspathUtils.toClassName((String)this.resource);
        try {
            return ClassUtil.forName((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (this.resource.equals(className)) {
                LOGGER.debug("Resource path [" + this.resource + "] looks as though it may be a Java resource reference.  If so, this class is not available on the classpath.");
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (this.resource.equals(className)) {
                LOGGER.debug("The string [" + this.resource + "] contains unescaped characters that are illegal in a Java resource name.");
            }
            return null;
        }
    }

    public boolean isJavaResource() {
        return this.toJavaResource() != null;
    }

    public void addChangeListener(ResourceConfigChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ResourceConfigChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public String toXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<resource-config selector=\"").append(this.selectorPath.getSelector()).append("\"");
        if (this.selectorPath.getSelectorNamespaceURI() != null) {
            builder.append(" selector-namespace=\"").append(this.selectorPath.getSelectorNamespaceURI()).append("\"");
        }
        if (this.targetProfile != null && !this.targetProfile.equals(Profile.DEFAULT_PROFILE)) {
            builder.append(" target-profile=\"").append(this.targetProfile).append("\"");
        }
        builder.append(">\n");
        if (this.resource != null) {
            String resourceStartEl = this.resourceType != null ? "<resource type=\"" + this.resourceType + "\">" : "<resource>";
            builder.append("\t").append(resourceStartEl);
            if (this.resource.length() < 300) {
                builder.append(this.resource).append("</resource>\n");
            } else {
                builder.append(this.resource, 0, 300).append(" ... more</resource>\n");
            }
        }
        if (this.selectorPath.getConditionEvaluator() != null) {
            builder.append("\t<condition evaluator=\"").append(this.selectorPath.getConditionEvaluator().getClass().getName()).append("\">").append(this.selectorPath.getConditionEvaluator().getExpression()).append("</condition>\n");
        }
        if (this.parameters != null) {
            Set<String> paramNames = this.parameters.keySet();
            for (String paramName : paramNames) {
                List<Parameter<?>> params = this.getParameters(paramName);
                for (Parameter<?> param : params) {
                    Element element = param.getXml();
                    Object value = element != null ? XmlUtil.serialize((NodeList)element.getChildNodes(), (boolean)true) : param.getValue();
                    builder.append("\t<param name=\"").append(paramName).append("\">").append(value).append("</param>\n");
                }
            }
        }
        builder.append("</resource-config>");
        return builder.toString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Set<String> names = this.parameters.keySet();
        for (String name : names) {
            properties.setProperty(name, this.getParameterValue(name).toString());
        }
        return properties;
    }

    private void fireChangedEvent() {
        if (!this.changeListeners.isEmpty()) {
            for (ResourceConfigChangeListener listener : this.changeListeners) {
                listener.changed((ResourceConfig)this);
            }
        }
    }
}

