/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.ConfigSearch;
import org.smooks.api.resource.config.ProfileTargetingExpression;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.assertion.AssertArgument;

public class DefaultResourceConfigSeq
implements ResourceConfigSeq {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceConfigSeq.class);
    private final String name;
    private boolean isSystemConfigList;
    private final List<ProfileSet> profiles = new ArrayList<ProfileSet>();
    private final List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();

    public DefaultResourceConfigSeq(String name) {
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in constructor call.");
        }
        this.name = name;
        LOGGER.debug("Smooks ResourceConfiguration List [" + name + "] created.");
    }

    public void add(ResourceConfig resourceConfig) {
        String[] selectors;
        AssertArgument.isNotNull((Object)resourceConfig, (String)"resourceConfig");
        for (String selector : selectors = resourceConfig.getSelectorPath().getSelector().split(",")) {
            ResourceConfig clone = resourceConfig.copy();
            clone.setSelector(selector.trim(), resourceConfig.getSelectorPath().getNamespaces());
            this.resourceConfigs.add(clone);
            LOGGER.debug("Smooks ResourceConfiguration [" + clone + "] added to list [" + this.name + "].");
        }
    }

    public void addAll(ResourceConfigSeq resourceConfigSeq) {
        this.resourceConfigs.addAll(resourceConfigSeq.getAll());
    }

    public void add(ProfileSet profileSet) {
        AssertArgument.isNotNull((Object)profileSet, (String)"profileSet");
        this.profiles.add(profileSet);
        LOGGER.debug("ProfileSet [" + profileSet.getBaseProfile() + "] added to list Smooks configuration [" + this.name + "].");
    }

    public String getName() {
        return this.name;
    }

    public boolean isSystemConfigList() {
        return this.isSystemConfigList;
    }

    public void setSystemConfigList(boolean systemConfigList) {
        this.isSystemConfigList = systemConfigList;
    }

    public boolean isEmpty() {
        return this.resourceConfigs.isEmpty();
    }

    public int size() {
        return this.resourceConfigs.size();
    }

    public ResourceConfig get(int index) throws ArrayIndexOutOfBoundsException {
        return this.resourceConfigs.get(index);
    }

    public List<ResourceConfig> getAll() throws ArrayIndexOutOfBoundsException {
        return this.resourceConfigs;
    }

    public List<ResourceConfig> getAll(ProfileSet profileSet) {
        ArrayList<ResourceConfig> matchingResourceConfigsColl = new ArrayList<ResourceConfig>();
        block0: for (int i = 0; i < this.size(); ++i) {
            ProfileTargetingExpression[] profileTargetingExpressions;
            ResourceConfig resourceConfig = this.get(i);
            for (ProfileTargetingExpression expression : profileTargetingExpressions = resourceConfig.getProfileTargetingExpressions()) {
                if (expression.isMatch(profileSet)) {
                    matchingResourceConfigsColl.add(resourceConfig);
                    continue block0;
                }
                LOGGER.debug("Resource [" + resourceConfig + "] not targeted at profile [" + profileSet.getBaseProfile() + "].  Sub Profiles: [" + profileSet + "]");
            }
        }
        return matchingResourceConfigsColl;
    }

    public List<ProfileSet> getProfiles() {
        return this.profiles;
    }

    public List<ResourceConfig> lookupResource(ConfigSearch searchCriteria) {
        ArrayList<ResourceConfig> results = new ArrayList<ResourceConfig>();
        for (ResourceConfig resourceConfig : this.resourceConfigs) {
            if (!searchCriteria.matches(resourceConfig)) continue;
            results.add(resourceConfig);
        }
        return results;
    }

    public Iterator<ResourceConfig> iterator() {
        return this.resourceConfigs.iterator();
    }
}

