/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.io.InputStream;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfigListFactory;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.resource.config.XMLConfigDigester;

public class SystemResourceConfigListFactory
implements ResourceConfigListFactory {
    private final ClassLoader classLoader;
    private final String resourceFile;

    public SystemResourceConfigListFactory(String resourceFile, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.resourceFile = resourceFile;
    }

    public ResourceConfigSeq create() {
        InputStream resource = this.getClass().getResourceAsStream(this.resourceFile);
        if (resource == null) {
            throw new IllegalStateException("Failed to load " + this.resourceFile);
        }
        try {
            ResourceConfigSeq resourceConfigList = XMLConfigDigester.digestConfig(resource, this.resourceFile, this.classLoader);
            for (int i = 0; i < resourceConfigList.size(); ++i) {
                resourceConfigList.get(i).setDefaultResource(true);
            }
            resourceConfigList.setSystemConfigList(true);
            return resourceConfigList;
        }
        catch (Exception e) {
            throw new SmooksException("Error processing resource file '" + this.resourceFile + "'.", (Throwable)e);
        }
    }
}

