/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.memento.VisitorMemento;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementPositionCounter
implements BeforeVisitor {
    private final SelectorStep selectorStep;
    private final TypedKey<String> positionMementoTypedKey = new TypedKey();

    public ElementPositionCounter(SelectorStep selectorStep) {
        this.selectorStep = selectorStep;
    }

    public SelectorStep getSelectorStep() {
        return this.selectorStep;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        Integer position = this.getElementPosition(element, executionContext);
        if (position != null) {
            VisitorMemento<Integer> positionMemento = new VisitorMemento<Integer>(new NodeFragment(element.getParentNode()), (Visitor)this, this.positionMementoTypedKey, position + 1);
            executionContext.getMementoCaretaker().capture(positionMemento);
        }
    }

    public int getCount(Element element, ExecutionContext executionContext) {
        Integer position = this.getElementPosition(element, executionContext);
        return position != null ? position : 0;
    }

    protected Integer getElementPosition(Element element, ExecutionContext executionContext) {
        Node parentNode = element.getParentNode();
        if (parentNode != null) {
            VisitorMemento<Integer> positionMemento = new VisitorMemento<Integer>(new NodeFragment(parentNode), (Visitor)this, this.positionMementoTypedKey, 0);
            executionContext.getMementoCaretaker().restore(positionMemento);
            return positionMemento.getState();
        }
        return null;
    }
}

