/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.List;
import java.util.ListIterator;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.DefaultAllNodeStep;
import org.jaxen.expr.DefaultCommentNodeStep;
import org.jaxen.expr.DefaultFilterExpr;
import org.jaxen.expr.DefaultNameStep;
import org.jaxen.expr.DefaultProcessingInstructionNodeStep;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.DefaultTextNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.UnionExpr;
import org.jaxen.expr.XPathFactory;
import org.jaxen.pattern.LocationPathPattern;
import org.jaxen.pattern.NameTest;
import org.jaxen.pattern.NamespaceTest;
import org.jaxen.pattern.NodeTest;
import org.jaxen.pattern.NodeTypeTest;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.TextNodeTest;
import org.jaxen.pattern.UnionPattern;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;

public class PatternParser {
    private static final boolean TRACE = false;
    private static final boolean USE_HANDLER = false;

    public static Pattern parse(String text) throws JaxenException, SAXPathException {
        XPathReader reader = XPathReaderFactory.createReader();
        JaxenHandler handler = new JaxenHandler();
        handler.setXPathFactory((XPathFactory)new DefaultXPathFactory());
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(text);
        Pattern pattern = PatternParser.convertExpr(handler.getXPathExpr().getRootExpr());
        return pattern.simplify();
    }

    protected static Pattern convertExpr(Expr expr) throws JaxenException {
        if (expr instanceof LocationPath) {
            return PatternParser.convertExpr((LocationPath)expr);
        }
        if (expr instanceof FilterExpr) {
            LocationPathPattern answer = new LocationPathPattern();
            answer.addFilter((FilterExpr)expr);
            return answer;
        }
        if (expr instanceof UnionExpr) {
            UnionExpr unionExpr = (UnionExpr)expr;
            Pattern lhs = PatternParser.convertExpr(unionExpr.getLHS());
            Pattern rhs = PatternParser.convertExpr(unionExpr.getRHS());
            return new UnionPattern(lhs, rhs);
        }
        LocationPathPattern answer = new LocationPathPattern();
        answer.addFilter((FilterExpr)new DefaultFilterExpr(expr, new PredicateSet()));
        return answer;
    }

    protected static LocationPathPattern convertExpr(LocationPath locationPath) throws JaxenException {
        LocationPathPattern answer = new LocationPathPattern();
        List steps = locationPath.getSteps();
        LocationPathPattern path = answer;
        boolean first = true;
        ListIterator iter = steps.listIterator(steps.size());
        while (iter.hasPrevious()) {
            Step step = (Step)iter.previous();
            if (first) {
                first = false;
                path = PatternParser.convertStep(path, step);
                continue;
            }
            if (PatternParser.navigationStep(step)) {
                LocationPathPattern parent = new LocationPathPattern();
                int axis = step.getAxis();
                if (axis == 2 || axis == 12) {
                    path.setAncestorPattern((Pattern)parent);
                } else {
                    path.setParentPattern((Pattern)parent);
                }
                path = parent;
            }
            path = PatternParser.convertStep(path, step);
        }
        if (locationPath.isAbsolute()) {
            LocationPathPattern parent = new LocationPathPattern((NodeTest)NodeTypeTest.DOCUMENT_TEST);
            path.setParentPattern((Pattern)parent);
        }
        return answer;
    }

    protected static LocationPathPattern convertStep(LocationPathPattern path, Step step) throws JaxenException {
        if (step instanceof DefaultAllNodeStep) {
            int axis = step.getAxis();
            if (axis == 9) {
                path.setNodeTest((NodeTest)NodeTypeTest.ATTRIBUTE_TEST);
            } else {
                path.setNodeTest((NodeTest)NodeTypeTest.ELEMENT_TEST);
            }
        } else if (step instanceof DefaultCommentNodeStep) {
            path.setNodeTest((NodeTest)NodeTypeTest.COMMENT_TEST);
        } else if (step instanceof DefaultProcessingInstructionNodeStep) {
            path.setNodeTest((NodeTest)NodeTypeTest.PROCESSING_INSTRUCTION_TEST);
        } else if (step instanceof DefaultTextNodeStep) {
            path.setNodeTest((NodeTest)TextNodeTest.SINGLETON);
        } else if (step instanceof DefaultCommentNodeStep) {
            path.setNodeTest((NodeTest)NodeTypeTest.COMMENT_TEST);
        } else {
            if (step instanceof DefaultNameStep) {
                DefaultNameStep nameStep = (DefaultNameStep)step;
                String localName = nameStep.getLocalName();
                String prefix = nameStep.getPrefix();
                int axis = nameStep.getAxis();
                short nodeType = 1;
                if (axis == 9) {
                    nodeType = 2;
                }
                if (nameStep.isMatchesAnyName()) {
                    if (prefix.length() == 0 || prefix.equals("*")) {
                        if (axis == 9) {
                            path.setNodeTest((NodeTest)NodeTypeTest.ATTRIBUTE_TEST);
                        } else {
                            path.setNodeTest((NodeTest)NodeTypeTest.ELEMENT_TEST);
                        }
                    } else {
                        path.setNodeTest((NodeTest)new NamespaceTest(prefix, nodeType));
                    }
                } else {
                    Object nodeTest;
                    NameTest nameTest = new NameTest(localName, nodeType);
                    if (prefix.length() > 0) {
                        NamespaceTest namespaceTest = new NamespaceTest(prefix, nodeType);
                        nodeTest = new NameNamespaceCompositeTest(nameTest, namespaceTest);
                    } else {
                        nodeTest = nameTest;
                    }
                    path.setNodeTest((NodeTest)nodeTest);
                }
                return PatternParser.convertDefaultStep(path, (DefaultStep)nameStep);
            }
            if (step instanceof DefaultStep) {
                return PatternParser.convertDefaultStep(path, (DefaultStep)step);
            }
            throw new JaxenException("Cannot convert: " + step + " to a Pattern");
        }
        return path;
    }

    protected static LocationPathPattern convertDefaultStep(LocationPathPattern path, DefaultStep step) throws JaxenException {
        List predicates = step.getPredicates();
        if (!predicates.isEmpty()) {
            DefaultFilterExpr filter = new DefaultFilterExpr(new PredicateSet());
            for (Predicate predicate : predicates) {
                if (predicate.getExpr() instanceof NumberExpr || PatternParser.containsTextNode(predicate.getExpr())) continue;
                filter.addPredicate(predicate);
            }
            if (!filter.getPredicates().isEmpty()) {
                path.addFilter((FilterExpr)filter);
            }
        }
        return path;
    }

    public static boolean containsTextNode(Expr expr) {
        if (expr instanceof LocationPath) {
            for (Object step : ((LocationPath)expr).getSteps()) {
                if (step instanceof TextNodeStep) {
                    return true;
                }
                for (Object predicate : ((Step)step).getPredicates()) {
                    if (!PatternParser.containsTextNode(((Predicate)predicate).getExpr())) continue;
                    return true;
                }
            }
        } else if (expr instanceof BinaryExpr) {
            return PatternParser.containsTextNode(((BinaryExpr)expr).getLHS()) || PatternParser.containsTextNode(((BinaryExpr)expr).getRHS());
        }
        return false;
    }

    protected static boolean navigationStep(Step step) {
        if (step instanceof DefaultNameStep) {
            return true;
        }
        if (step.getClass().equals(DefaultStep.class)) {
            return !step.getPredicates().isEmpty();
        }
        return true;
    }

    protected static class NameNamespaceCompositeTest
    extends NodeTest {
        private final NameTest nameTest;
        private final NamespaceTest namespaceTest;

        public NameNamespaceCompositeTest(NameTest nameTest, NamespaceTest namespaceTest) {
            this.nameTest = nameTest;
            this.namespaceTest = namespaceTest;
        }

        public boolean matches(Object node, Context context) throws JaxenException {
            return this.nameTest.matches(node, context) && this.namespaceTest.matches(node, context);
        }

        public String getText() {
            return this.namespaceTest.getText() + this.nameTest.getText();
        }
    }
}

