/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.resource.config.xpath.SelectorPathJaxenHandler;

public final class SelectorPathFactory {
    private SelectorPathFactory() {
    }

    public static SelectorPath newSelectorPath(String selector) {
        return SelectorPathFactory.newSelectorPath(selector, new Properties());
    }

    public static SelectorPath newSelectorPath(SelectorPath selectorPath) {
        return SelectorPathFactory.newSelectorPath(selectorPath.getSelector(), selectorPath);
    }

    public static SelectorPath newSelectorPath(String selector, SelectorPath selectorPath) {
        SelectorPath newSelectorPath = SelectorPathFactory.newSelectorPath(selector, selectorPath.getNamespaces());
        newSelectorPath.setSelectorNamespaceURI(selectorPath.getSelectorNamespaceURI());
        newSelectorPath.setConditionEvaluator(selectorPath.getConditionEvaluator());
        return newSelectorPath;
    }

    public static SelectorPath newSelectorPath(String selector, Properties namespaces) {
        AssertArgument.isNotEmpty((String)selector, (String)"selector");
        int docSelectorIndex = selector.trim().indexOf("#document");
        if (docSelectorIndex > 0) {
            throw new SmooksConfigException("Invalid selector '" + selector + "'.  '" + "#document" + "' token can only exist at the start of the selector.");
        }
        SelectorPath selectorPath = SelectorPathFactory.buildSelectorPath(selector, namespaces);
        if (namespaces != null) {
            selectorPath.setNamespaces(namespaces);
        }
        return selectorPath;
    }

    private static SelectorPath buildSelectorPath(String selector, Properties namespaces) {
        SelectorPath selectorPath = "none".equals(selector) ? SelectorPathFactory._buildSelectorPath("none", namespaces) : SelectorPathFactory._buildSelectorPath(selector, namespaces);
        return selectorPath;
    }

    private static SelectorPath _buildSelectorPath(final String selector, Properties namespaces) {
        XPathReader reader;
        AssertArgument.isNotNull((Object)selector, (String)"selector");
        String xpathExpression = selector.replaceAll("#document", "/*");
        try {
            reader = XPathReaderFactory.createReader();
        }
        catch (SAXPathException e) {
            throw new SmooksException((Throwable)e);
        }
        try {
            reader.parse(xpathExpression);
        }
        catch (SAXPathException e) {
            if (selector.split(",").length > 1) {
                return new SelectorPath(){

                    public String getSelector() {
                        return selector;
                    }

                    public String getSelectorNamespaceURI() {
                        return null;
                    }

                    public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
                    }

                    public ExpressionEvaluator getConditionEvaluator() {
                        return null;
                    }

                    public void setSelectorNamespaceURI(String namespaceURI) {
                    }

                    public Properties getNamespaces() {
                        return new Properties();
                    }

                    public void setNamespaces(Properties namespaces) {
                    }

                    public int size() {
                        return 0;
                    }

                    public boolean isEmpty() {
                        return false;
                    }

                    public boolean contains(Object o) {
                        return false;
                    }

                    public Iterator<SelectorStep> iterator() {
                        return null;
                    }

                    public Object[] toArray() {
                        return new Object[0];
                    }

                    public <T> T[] toArray(T[] a) {
                        return null;
                    }

                    public boolean add(SelectorStep selectorStep) {
                        return false;
                    }

                    public boolean remove(Object o) {
                        return false;
                    }

                    public boolean containsAll(Collection<?> c) {
                        return false;
                    }

                    public boolean addAll(Collection<? extends SelectorStep> c) {
                        return false;
                    }

                    public boolean addAll(int index, Collection<? extends SelectorStep> c) {
                        return false;
                    }

                    public boolean removeAll(Collection<?> c) {
                        return false;
                    }

                    public boolean retainAll(Collection<?> c) {
                        return false;
                    }

                    public void clear() {
                    }

                    public SelectorStep get(int index) {
                        return null;
                    }

                    public SelectorStep set(int index, SelectorStep element) {
                        return null;
                    }

                    public void add(int index, SelectorStep element) {
                    }

                    public SelectorStep remove(int index) {
                        return null;
                    }

                    public int indexOf(Object o) {
                        return 0;
                    }

                    public int lastIndexOf(Object o) {
                        return 0;
                    }

                    public ListIterator<SelectorStep> listIterator() {
                        return null;
                    }

                    public ListIterator<SelectorStep> listIterator(int index) {
                        return null;
                    }

                    public List<SelectorStep> subList(int fromIndex, int toIndex) {
                        return null;
                    }
                };
            }
            throw new SmooksException((Throwable)e);
        }
        SelectorPathJaxenHandler xpathHandler = new SelectorPathJaxenHandler(xpathExpression, namespaces);
        if (xpathExpression.trim().length() > 0) {
            reader.setXPathHandler((XPathHandler)xpathHandler);
            try {
                reader.parse(xpathExpression);
            }
            catch (SAXPathException e) {
                throw new SmooksException((Throwable)e);
            }
        }
        return xpathHandler.getSelectorPath();
    }
}

