/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.SimpleSelectorPath;
import org.smooks.engine.resource.config.xpath.predicate.AttributePredicate;
import org.smooks.engine.resource.config.xpath.predicate.DefaultPredicateEvaluator;
import org.smooks.engine.resource.config.xpath.predicate.PositionPredicateEvaluator;
import org.smooks.engine.resource.config.xpath.step.AllSelectorStep;
import org.smooks.engine.resource.config.xpath.step.AttributeSelectorStep;
import org.smooks.engine.resource.config.xpath.step.DocumentSelectorStep;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class SelectorPathJaxenHandler
extends JaxenHandler {
    private final String selector;
    private final Properties namespaces;
    private SelectorPath selectorPath;
    private boolean isTextNode = false;
    private boolean isPredicate = false;

    public SelectorPathJaxenHandler(String selector, Properties namespaces) {
        this.selector = selector;
        this.namespaces = namespaces;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        super.setXPathFactory(xpathFactory);
    }

    public XPathFactory getXPathFactory() {
        return super.getXPathFactory();
    }

    public XPathExpr getXPathExpr() {
        return super.getXPathExpr();
    }

    public XPathExpr getXPathExpr(boolean shouldSimplify) {
        return super.getXPathExpr(shouldSimplify);
    }

    public void startXPath() {
        super.startXPath();
    }

    public void endXPath() throws JaxenException {
        super.endXPath();
    }

    public void startPathExpr() {
        super.startPathExpr();
    }

    public void endPathExpr() throws JaxenException {
        super.endPathExpr();
    }

    public void startAbsoluteLocationPath() throws JaxenException {
        this.selectorPath = new IndexedSelectorPath(this.selector);
        this.selectorPath.add((Object)new DocumentSelectorStep());
        super.startAbsoluteLocationPath();
    }

    public void endAbsoluteLocationPath() throws JaxenException {
        super.endAbsoluteLocationPath();
    }

    public void startRelativeLocationPath() throws JaxenException {
        if (this.selectorPath == null) {
            this.selectorPath = new IndexedSelectorPath(this.selector);
        }
        super.startRelativeLocationPath();
    }

    public void endRelativeLocationPath() throws JaxenException {
        super.endRelativeLocationPath();
    }

    protected void endLocationPath() throws JaxenException {
        super.endLocationPath();
    }

    protected void addSteps(LocationPath locationPath, Iterator stepIter) {
        super.addSteps(locationPath, stepIter);
    }

    public void startNameStep(int axis, String prefix, String localName) throws JaxenException {
        if (axis == 9) {
            if (this.isPredicate) {
                ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new AttributePredicate(this.namespaces.getProperty(prefix), localName));
            } else {
                this.selectorPath.add((Object)new AttributeSelectorStep(this.namespaces.getProperty(prefix), localName, prefix));
            }
        } else if (!(this.selectorPath instanceof IndexedSelectorPath && localName.equals("*") && ((IndexedSelectorPath)this.selectorPath).getTargetSelectorStep() instanceof DocumentSelectorStep || this.isPredicate)) {
            this.selectorPath.add((Object)new ElementSelectorStep(this.namespaces.getProperty(prefix), localName, prefix));
        }
        super.startNameStep(axis, prefix, localName);
    }

    public void endNameStep() {
        super.endNameStep();
    }

    public void startTextNodeStep(int axis) throws JaxenException {
        this.isTextNode = true;
        super.startTextNodeStep(axis);
    }

    public void endTextNodeStep() {
        super.endTextNodeStep();
    }

    public void startCommentNodeStep(int axis) throws JaxenException {
        super.startCommentNodeStep(axis);
    }

    public void endCommentNodeStep() {
        super.endCommentNodeStep();
    }

    public void startAllNodeStep(int axis) throws JaxenException {
        this.selectorPath.add((Object)new AllSelectorStep());
        super.startAllNodeStep(axis);
    }

    public void endAllNodeStep() {
        super.endAllNodeStep();
    }

    public void startProcessingInstructionNodeStep(int axis, String name) throws JaxenException {
        super.startProcessingInstructionNodeStep(axis, name);
    }

    public void endProcessingInstructionNodeStep() {
        super.endProcessingInstructionNodeStep();
    }

    protected void endStep() {
        super.endStep();
    }

    public void startPredicate() {
        this.isPredicate = true;
        super.startPredicate();
    }

    public void endPredicate() throws JaxenException {
        Expr expr = (Expr)this.peekFrame().getFirst();
        SelectorStep currentSelectorStep = (SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1);
        if (expr instanceof PathExpr) {
            if (((PathExpr)expr).getFilterExpr() != null) {
                if (((FilterExpr)((PathExpr)expr).getFilterExpr()).getExpr() instanceof NumberExpr) {
                    ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new PositionPredicateEvaluator(expr, ((ElementSelectorStep)currentSelectorStep).getQName().getLocalPart(), ((ElementSelectorStep)currentSelectorStep).getQName().getNamespaceURI()));
                } else {
                    ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new DefaultPredicateEvaluator(expr));
                }
            }
        } else if (expr instanceof BinaryExpr && this.isTextNode) {
            ((ElementSelectorStep)currentSelectorStep).setAccessesText(true);
            currentSelectorStep.getPredicates().add(new DefaultPredicateEvaluator(expr));
        }
        this.isTextNode = false;
        this.isPredicate = false;
        super.endPredicate();
    }

    public void startFilterExpr() {
        super.startFilterExpr();
    }

    public void endFilterExpr() throws JaxenException {
        super.endFilterExpr();
    }

    protected void addPredicates(Predicated obj, Iterator predIter) {
        super.addPredicates(obj, predIter);
    }

    protected void returnExpr() {
        super.returnExpr();
    }

    public void startOrExpr() {
        super.startOrExpr();
    }

    public void endOrExpr(boolean create) throws JaxenException {
        super.endOrExpr(create);
    }

    public void startAndExpr() {
        super.startAndExpr();
    }

    public void endAndExpr(boolean create) throws JaxenException {
        super.endAndExpr(create);
    }

    public void startEqualityExpr() {
        super.startEqualityExpr();
    }

    public void endEqualityExpr(int operator) throws JaxenException {
        super.endEqualityExpr(operator);
    }

    public void startRelationalExpr() {
        super.startRelationalExpr();
    }

    public void endRelationalExpr(int operator) throws JaxenException {
        super.endRelationalExpr(operator);
    }

    public void startAdditiveExpr() {
        super.startAdditiveExpr();
    }

    public void endAdditiveExpr(int operator) throws JaxenException {
        super.endAdditiveExpr(operator);
    }

    public void startMultiplicativeExpr() {
        super.startMultiplicativeExpr();
    }

    public void endMultiplicativeExpr(int operator) throws JaxenException {
        super.endMultiplicativeExpr(operator);
    }

    public void startUnaryExpr() {
        super.startUnaryExpr();
    }

    public void endUnaryExpr(int operator) throws JaxenException {
        super.endUnaryExpr(operator);
    }

    public void startUnionExpr() {
        super.startUnionExpr();
    }

    public void endUnionExpr(boolean create) throws JaxenException {
        super.endUnionExpr(create);
    }

    public void number(int number) throws JaxenException {
        super.number(number);
    }

    public void number(double number) throws JaxenException {
        super.number(number);
    }

    public void literal(String literal) throws JaxenException {
        super.literal(literal);
    }

    public void variableReference(String prefix, String variableName) throws JaxenException {
        super.variableReference(prefix, variableName);
    }

    public void startFunction(String prefix, String functionName) throws JaxenException {
        if (this.selectorPath == null) {
            this.selectorPath = new SimpleSelectorPath(this.selector);
        }
        super.startFunction(prefix, functionName);
    }

    public void endFunction() {
        super.endFunction();
    }

    protected void addParameters(FunctionCallExpr function, Iterator paramIter) {
        super.addParameters(function, paramIter);
    }

    protected int stackSize() {
        return super.stackSize();
    }

    protected void push(Object obj) {
        super.push(obj);
    }

    protected Object pop() {
        return super.pop();
    }

    protected boolean canPop() {
        return super.canPop();
    }

    protected void pushFrame() {
        super.pushFrame();
    }

    protected LinkedList popFrame() {
        return super.popFrame();
    }

    protected LinkedList peekFrame() {
        return super.peekFrame();
    }

    public SelectorPath getSelectorPath() {
        return this.selectorPath;
    }

    public String getSelector() {
        return this.selector;
    }
}

