/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.extension;

import java.util.Optional;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.engine.resource.extension.ExtensionContext;
import org.smooks.engine.resource.extension.ResourceConfigUtil;
import org.w3c.dom.Element;

public class CloneResourceConfig
implements DOMElementVisitor {
    @Inject
    private Optional<String> resource;
    @Inject
    private Optional<String[]> unset;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = (ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
        ResourceConfig config = extensionContext.getResourceStack().peek().copy();
        if (this.unset.isPresent()) {
            for (String property : this.unset.get()) {
                ResourceConfigUtil.unsetProperty(config, property);
            }
        }
        this.resource.ifPresent(arg_0 -> ((ResourceConfig)config).setResource(arg_0));
        extensionContext.addResource(config);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        ((ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY)).getResourceStack().pop();
    }
}

