/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.smooks.api.TypedKey;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.ConfigSearch;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigChangeListener;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.resource.config.XMLConfigDigester;

public class ExtensionContext {
    public static final TypedKey<ExtensionContext> EXTENSION_CONTEXT_TYPED_KEY = new TypedKey();
    private final XMLConfigDigester xmlConfigDigester;
    @Deprecated
    private final String defaultSelector;
    @Deprecated
    private final String defaultNamespace;
    private final String defaultProfile;
    private final ExpressionEvaluator defaultConditionEvaluator;
    private final Stack<ResourceConfig> resourceStack = new Stack<ResourceConfig>(){

        @Override
        public ResourceConfig push(ResourceConfig resourceConfiguration) {
            if (!this.isEmpty()) {
                resourceConfiguration.addChangeListener(ExtensionContext.this.resChangeListener);
            }
            return super.push(resourceConfiguration);
        }

        @Override
        public ResourceConfig pop() {
            ResourceConfig resourceConfig = (ResourceConfig)super.pop();
            if (!this.isEmpty()) {
                resourceConfig.removeChangeListener(ExtensionContext.this.resChangeListener);
            }
            return resourceConfig;
        }
    };
    private final ResourceConfigChangeListener resChangeListener = resourceConfig -> {
        String selector = resourceConfig.getSelectorPath().getSelector();
        if (selector != null && selector.startsWith("#/")) {
            ResourceConfig parentResource = (ResourceConfig)this.resourceStack.get(this.resourceStack.size() - 2);
            resourceConfig.setSelector(parentResource.getSelectorPath().getSelector() + selector.substring(1), new Properties());
        }
    };
    private final List<ResourceConfig> resources = new ArrayList<ResourceConfig>();

    public ExtensionContext(XMLConfigDigester xmlConfigDigester, @Deprecated String defaultSelector, @Deprecated String defaultNamespace, String defaultProfile, ExpressionEvaluator defaultConditionEvaluator) {
        this.xmlConfigDigester = xmlConfigDigester;
        this.defaultSelector = defaultSelector;
        this.defaultNamespace = defaultNamespace;
        this.defaultProfile = defaultProfile;
        this.defaultConditionEvaluator = defaultConditionEvaluator;
    }

    public void addResource(ResourceConfig resource) {
        this.resourceStack.push(resource);
        this.resources.add(resource);
    }

    public void addResourceTemplate(ResourceConfig resourceConfig) {
        this.resourceStack.push(resourceConfig);
    }

    public Stack<ResourceConfig> getResourceStack() {
        return this.resourceStack;
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public ResourceConfigSeq getResourceList() {
        return this.xmlConfigDigester.getResourceList();
    }

    public ResourceConfig getCurrentConfig() {
        if (this.resourceStack.isEmpty()) {
            return null;
        }
        return this.resourceStack.peek();
    }

    public XMLConfigDigester getXmlConfigDigester() {
        return this.xmlConfigDigester;
    }

    @Deprecated
    public String getDefaultSelector() {
        return this.defaultSelector;
    }

    @Deprecated
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public ExpressionEvaluator getDefaultConditionEvaluator() {
        return this.defaultConditionEvaluator;
    }

    public ResourceConfig getResourceByName(String name) {
        for (int i = this.resourceStack.size() - 1; i >= 0; --i) {
            ResourceConfig resourceConfig = (ResourceConfig)this.resourceStack.get(i);
            String resourceName = resourceConfig.getResource();
            if (!name.equals(resourceName)) continue;
            return resourceConfig;
        }
        return null;
    }

    public List<ResourceConfig> lookupResource(ConfigSearch searchCriteria) {
        return this.xmlConfigDigester.getResourceList().lookupResource(searchCriteria);
    }
}

