/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.extension;

import java.util.EmptyStackException;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.resource.extension.ExtensionContext;
import org.smooks.engine.resource.extension.ResourceConfigUtil;
import org.w3c.dom.Element;

public class MapToResourceConfigFromParentConfig
implements DOMVisitBefore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapToResourceConfigFromParentConfig.class);
    @Inject
    private int parentRelIndex = -1;
    @Inject
    private String mapFrom;
    @Inject
    private Optional<String> mapTo;
    @Inject
    private Optional<String> defaultValue;

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        if (this.parentRelIndex >= 0) {
            throw new SmooksConfigException("param 'parentRelIndex' value must be negative.  Value is '" + this.parentRelIndex + "'.");
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ResourceConfig parentConfig;
        ResourceConfig currentConfig;
        Stack<ResourceConfig> resourceStack = ((ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY)).getResourceStack();
        String actualMapTo = this.mapTo.orElse(null);
        if (actualMapTo == null) {
            actualMapTo = this.mapFrom;
        }
        try {
            currentConfig = resourceStack.peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No ResourceConfig available in ExtensionContext stack.  Unable to set ResourceConfig property '" + actualMapTo + "' with element text value.");
        }
        try {
            parentConfig = (ResourceConfig)resourceStack.get(resourceStack.size() - 1 + this.parentRelIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SmooksException("No Parent ResourceConfig available in ExtensionContext stack at relative index '" + this.parentRelIndex + "'.  Unable to set ResourceConfig property '" + actualMapTo + "' with value of '" + this.mapFrom + "' from parent configuration.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mapping property '" + this.mapFrom + "' on parent resource configuration to property'" + actualMapTo + "'.");
        }
        ResourceConfigUtil.mapProperty(parentConfig, this.mapFrom, currentConfig, actualMapTo, this.defaultValue.orElse(null), executionContext);
    }
}

