/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.extension;

import java.util.EmptyStackException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.resource.extension.ExtensionContext;
import org.smooks.engine.resource.extension.ResourceConfigUtil;
import org.w3c.dom.Element;

public class SetOnResourceConfig
implements DOMVisitBefore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetOnResourceConfig.class);
    @Inject
    private String setOn;
    @Inject
    private String value;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ResourceConfig config;
        try {
            config = ((ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY)).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No ResourceConfig available in ExtensionContext stack.  Unable to set ResourceConfig property '" + this.setOn + "' with static value.");
        }
        LOGGER.debug("Setting property '" + this.setOn + "' on resource configuration to a value of '" + this.value + "'.");
        ResourceConfigUtil.setProperty(config, this.setOn, this.value, executionContext);
    }
}

