/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.smooks.FilterSettings;
import org.smooks.Smooks;
import org.smooks.StreamFilterType;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorChainFactory;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorDefinition;
import org.smooks.engine.delivery.interceptor.StaticProxyInterceptor;
import org.smooks.engine.delivery.sax.ng.session.Session;
import org.smooks.engine.delivery.sax.ng.session.SessionInterceptor;
import org.smooks.engine.resource.config.XMLConfigDigester;
import org.smooks.io.DocumentInputSource;
import org.smooks.io.SAXWriter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DelegateReader
implements SmooksXMLReader {
    private final TypedKey<Writer> contentHandlerTypedKey = new TypedKey();
    private final TypedKey<ExecutionContext> executionContextTypedKey = new TypedKey();
    private ContentHandler contentHandler;
    private Smooks readerSmooks;
    private ErrorHandler errorHandler;
    private ExecutionContext executionContext;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;
    private DocumentBuilder documentBuilder;

    @PostConstruct
    public void postConstruct() {
        ResourceConfigSeq resourceConfigList;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException((Throwable)e);
        }
        String smooksResourceList = "<smooks-resource-list xmlns=\"https://www.smooks.org/xsd/smooks-2.0.xsd\">" + (String)this.resourceConfig.getParameter("resourceConfigs", String.class).getValue() + "</smooks-resource-list>";
        try {
            resourceConfigList = XMLConfigDigester.digestConfig(new ByteArrayInputStream(smooksResourceList.getBytes(StandardCharsets.UTF_8)), "./", new HashMap<String, Smooks>(), this.applicationContext.getClassLoader());
        }
        catch (IOException | URISyntaxException | SAXException e) {
            throw new SmooksException((Throwable)e);
        }
        this.readerSmooks = new Smooks(new DefaultApplicationContextBuilder().setRegisterSystemResources(false).setClassLoader(this.applicationContext.getClassLoader()).build());
        this.readerSmooks.setFilterSettings(new FilterSettings(StreamFilterType.SAX_NG).setCloseResult(false).setReaderPoolSize(-1));
        for (ResourceConfig resourceConfig : resourceConfigList) {
            this.readerSmooks.addConfiguration(resourceConfig);
        }
        InterceptorVisitorChainFactory interceptorVisitorChainFactory = new InterceptorVisitorChainFactory();
        interceptorVisitorChainFactory.setApplicationContext(this.applicationContext);
        InterceptorVisitorDefinition sessionInterceptorVisitorDefinition = new InterceptorVisitorDefinition();
        sessionInterceptorVisitorDefinition.setSelector(Optional.of("*"));
        sessionInterceptorVisitorDefinition.setClass(SessionInterceptor.class);
        InterceptorVisitorDefinition staticProxyInterceptorVisitorDefinition = new InterceptorVisitorDefinition();
        staticProxyInterceptorVisitorDefinition.setSelector(Optional.of("*"));
        staticProxyInterceptorVisitorDefinition.setClass(StaticProxyInterceptor.class);
        interceptorVisitorChainFactory.getInterceptorVisitorDefinitions().add(sessionInterceptorVisitorDefinition);
        interceptorVisitorChainFactory.getInterceptorVisitorDefinitions().add(staticProxyInterceptorVisitorDefinition);
        this.readerSmooks.getApplicationContext().getRegistry().registerObject((Object)interceptorVisitorChainFactory);
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        Document document;
        if (inputSource instanceof DocumentInputSource) {
            document = ((DocumentInputSource)inputSource).getDocument();
        } else {
            document = this.documentBuilder.parse(inputSource);
            document.setStrictErrorChecking(false);
        }
        ExecutionContext readerExecutionContext = (ExecutionContext)this.executionContext.get(this.executionContextTypedKey);
        if (readerExecutionContext == null) {
            readerExecutionContext = this.readerSmooks.createExecutionContext();
            this.executionContext.put(this.executionContextTypedKey, (Object)readerExecutionContext);
        }
        if (Session.isSession(document.getFirstChild())) {
            Session session = new Session(document.getFirstChild());
            readerExecutionContext.put(session.getSourceKey(), (Object)session.getSourceValue(this.executionContext));
        }
        if (this.executionContext.get(this.contentHandlerTypedKey) == null) {
            this.executionContext.put(this.contentHandlerTypedKey, (Object)new SAXWriter(this.contentHandler));
        }
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter((Writer)this.executionContext.get(this.contentHandlerTypedKey));
        this.readerSmooks.filterSource(readerExecutionContext, new DOMSource(document), streamResult);
    }

    public void parse(String systemId) throws IOException, SAXException {
    }
}

