/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.dom;

import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.engine.delivery.event.EndFragmentEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.sax.ng.CharDataFragmentEvent;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;
import org.smooks.engine.resource.visitor.dom.DOMModel;
import org.smooks.support.CollectionsUtil;
import org.smooks.support.DomUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomModelCreator
implements BeforeVisitor,
AfterVisitor,
Producer {
    private static final TypedKey<Stack<DOMCreator>> DOM_CREATOR_STACK_TYPED_KEY = new TypedKey();
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    @Inject
    private ResourceConfig resourceConfig;

    public Set<String> getProducts() {
        if (this.resourceConfig.getSelectorPath() instanceof IndexedSelectorPath) {
            return CollectionsUtil.toSet((Object[])new String[]{((ElementSelectorStep)((IndexedSelectorPath)this.resourceConfig.getSelectorPath()).getTargetSelectorStep()).getQName().getLocalPart()});
        }
        return Collections.emptySet();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.pushCreator(new DOMCreator(executionContext), executionContext);
    }

    private void addNodeModel(Element element, ExecutionContext executionContext) {
        DOMModel nodeModel = DOMModel.getModel(executionContext);
        nodeModel.getModels().put(DomUtils.getName(element), element);
    }

    private void pushCreator(DOMCreator domCreator, ExecutionContext executionContext) {
        Stack<DOMCreator> domCreatorStack = (Stack<DOMCreator>)executionContext.get(DOM_CREATOR_STACK_TYPED_KEY);
        if (domCreatorStack == null) {
            domCreatorStack = new Stack<DOMCreator>();
            executionContext.put(DOM_CREATOR_STACK_TYPED_KEY, domCreatorStack);
        } else if (!domCreatorStack.isEmpty()) {
            executionContext.getContentDeliveryRuntime().removeExecutionEventListener((ExecutionEventListener)domCreatorStack.peek());
        }
        executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)domCreator);
        domCreatorStack.push(domCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document popCreator(ExecutionContext executionContext) {
        Stack domCreatorStack = (Stack)executionContext.get(DOM_CREATOR_STACK_TYPED_KEY);
        if (domCreatorStack == null) {
            throw new IllegalStateException("No DOM Creator Stack available.");
        }
        try {
            if (!domCreatorStack.isEmpty()) {
                DOMCreator removedCreator = (DOMCreator)domCreatorStack.pop();
                executionContext.getContentDeliveryRuntime().removeExecutionEventListener((ExecutionEventListener)removedCreator);
                Document document = removedCreator.document;
                return document;
            }
            Document document = null;
            return document;
        }
        finally {
            if (!domCreatorStack.isEmpty()) {
                executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)domCreatorStack.peek());
            }
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.popCreator(executionContext);
    }

    private class DOMCreator
    implements ExecutionEventListener {
        private final Document document;
        private final ExecutionContext executionContext;
        private Node currentNode;

        private DOMCreator(ExecutionContext executionContext) {
            this.document = DomModelCreator.this.documentBuilder.newDocument();
            this.document.setStrictErrorChecking(false);
            this.currentNode = this.document;
            this.executionContext = executionContext;
        }

        public void onEvent(ExecutionEvent executionEvent) {
            if (executionEvent instanceof StartFragmentEvent) {
                StartFragmentEvent startFragmentEvent = (StartFragmentEvent)executionEvent;
                Fragment fragment = startFragmentEvent.getFragment();
                Element importNode = (Element)this.document.importNode((Node)fragment.unwrap(), true);
                if (this.currentNode == this.document) {
                    DomModelCreator.this.addNodeModel(importNode, this.executionContext);
                }
                this.currentNode.appendChild(importNode);
                this.currentNode = importNode;
            } else if (executionEvent instanceof CharDataFragmentEvent) {
                if (this.currentNode == this.document) {
                    return;
                }
                CharacterData characterData = (CharacterData)((CharDataFragmentEvent)executionEvent).getFragment().unwrap();
                String textContent = characterData.getTextContent();
                if (textContent.trim().length() == 0) {
                    return;
                }
                switch (characterData.getNodeType()) {
                    case 3: 
                    case 6: {
                        this.currentNode.appendChild(this.document.createTextNode(textContent));
                        break;
                    }
                    case 4: {
                        this.currentNode.appendChild(this.document.createCDATASection(textContent));
                        break;
                    }
                    case 8: {
                        this.currentNode.appendChild(this.document.createComment(textContent));
                    }
                }
            } else if (executionEvent instanceof EndFragmentEvent) {
                this.currentNode = this.currentNode.getParentNode();
            }
        }
    }
}

