/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.smooks;

import java.io.Writer;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.delivery.event.EndFragmentEvent;
import org.smooks.engine.delivery.event.FragmentEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.sax.ng.CharDataFragmentEvent;
import org.smooks.engine.delivery.sax.ng.session.SessionAwareExecutionEventListener;
import org.smooks.engine.memento.SimpleVisitorMemento;
import org.smooks.engine.memento.VisitorMemento;
import org.smooks.engine.resource.visitor.smooks.NestedSmooksVisitor;
import org.w3c.dom.Node;

class ChildEventListener
extends SessionAwareExecutionEventListener {
    private final NestedSmooksVisitor nestedSmooksVisitor;
    private final NodeFragment visitedFragment;
    private final Writer selectorWriter;
    private int currentNodeDepth;

    public ChildEventListener(NestedSmooksVisitor nestedSmooksVisitor, Writer selectorWriter, NodeFragment visitedFragment, ExecutionContext executionContext) {
        super(executionContext);
        this.nestedSmooksVisitor = nestedSmooksVisitor;
        this.selectorWriter = selectorWriter;
        this.visitedFragment = visitedFragment;
    }

    @Override
    public void doOnEvent(ExecutionEvent executionEvent) {
        if (executionEvent instanceof FragmentEvent) {
            Fragment childFragment = ((FragmentEvent)executionEvent).getFragment();
            SimpleVisitorMemento<Node> sourceTreeMemento = new SimpleVisitorMemento<Node>(this.visitedFragment, (Visitor)this.nestedSmooksVisitor, this.visitedFragment.unwrap());
            this.executionContext.getMementoCaretaker().restore(sourceTreeMemento);
            if (executionEvent instanceof StartFragmentEvent) {
                if (!this.visitedFragment.equals(childFragment)) {
                    this.visitBefore(sourceTreeMemento, childFragment);
                }
            } else if (executionEvent instanceof CharDataFragmentEvent) {
                this.visitChildText(sourceTreeMemento, childFragment);
            } else if (executionEvent instanceof EndFragmentEvent && !this.visitedFragment.equals(childFragment)) {
                this.visitAfter(sourceTreeMemento);
            }
        }
    }

    protected void visitBefore(VisitorMemento<Node> sourceTreeMemento, Fragment<Node> childFragment) {
        Node childNode = sourceTreeMemento.getState().getOwnerDocument().importNode((Node)childFragment.unwrap(), true);
        this.nestedSmooksVisitor.filterSource(this.visitedFragment, new NodeFragment(sourceTreeMemento.getState().appendChild(childNode)), this.selectorWriter, this.executionContext, "visitBefore");
        ++this.currentNodeDepth;
        this.executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Node>(this.visitedFragment, (Visitor)this.nestedSmooksVisitor, childNode));
    }

    protected void visitChildText(VisitorMemento<Node> sourceTreeMemento, Fragment<Node> childFragment) {
        Node childNode = sourceTreeMemento.getState().getOwnerDocument().importNode((Node)childFragment.unwrap(), true);
        this.nestedSmooksVisitor.filterSource(this.visitedFragment, new NodeFragment(sourceTreeMemento.getState().appendChild(childNode)), this.selectorWriter, this.executionContext, "visitChildText");
        if (this.currentNodeDepth + 1 >= this.nestedSmooksVisitor.getMaxNodeDepth()) {
            sourceTreeMemento.getState().removeChild(childNode);
        }
    }

    protected void visitAfter(VisitorMemento<Node> sourceTreeMemento) {
        this.nestedSmooksVisitor.filterSource(this.visitedFragment, new NodeFragment(sourceTreeMemento.getState()), this.selectorWriter, this.executionContext, "visitAfter");
        Node parentNode = sourceTreeMemento.getState().getParentNode();
        if (this.currentNodeDepth >= this.nestedSmooksVisitor.getMaxNodeDepth()) {
            parentNode.removeChild(sourceTreeMemento.getState());
        }
        this.executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Node>(this.visitedFragment, (Visitor)this.nestedSmooksVisitor, parentNode));
        --this.currentNodeDepth;
    }
}

