/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jaxen.saxpath.SAXPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.lookup.ResourceConfigListsLookup;
import org.smooks.namespace.NamespaceDeclarationStack;

public class NamespaceManager {
    public static final TypedKey<NamespaceDeclarationStack> NAMESPACE_DECLARATION_STACK_TYPED_KEY = new TypedKey();
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceManager.class);
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void postConstruct() throws SAXPathException {
        Properties newNamespaces = this.resourceConfig.toProperties();
        for (ResourceConfigSeq resourceConfigList : (List)this.applicationContext.getRegistry().lookup((Function)new ResourceConfigListsLookup())) {
            for (int i = 0; i < resourceConfigList.size(); ++i) {
                resourceConfigList.get(i).getSelectorPath().setNamespaces(newNamespaces);
            }
        }
        LOGGER.debug("Adding namespace prefix-to-uri mappings: " + newNamespaces);
        Properties currentNamespaces = (Properties)this.applicationContext.getRegistry().lookup((Function)new NamespaceManagerLookup(false));
        if (currentNamespaces != null) {
            currentNamespaces.putAll((Map<?, ?>)newNamespaces);
        } else {
            this.applicationContext.getRegistry().registerObject(NamespaceManager.class, (Object)newNamespaces);
        }
    }
}

