/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.io.AbstractOutputStreamResource;

public class ResourceOutputStream
extends OutputStream {
    private final OutputStream delegateOutputStream;

    public ResourceOutputStream(ExecutionContext executionContext, String resourceName) {
        this.delegateOutputStream = this.getOutputStream(resourceName, executionContext);
    }

    @Override
    public void write(int b) throws IOException {
    }

    protected OutputStream getOutputStream(String resourceName, ExecutionContext executionContext) throws SmooksException {
        TypedKey resourceKey = new TypedKey(AbstractOutputStreamResource.OUTPUTSTREAM_CONTEXT_KEY_PREFIX + resourceName);
        Object resourceIOObj = executionContext.get(resourceKey);
        if (resourceIOObj == null) {
            AbstractOutputStreamResource resource = (AbstractOutputStreamResource)executionContext.get(new TypedKey(AbstractOutputStreamResource.RESOURCE_CONTEXT_KEY_PREFIX + resourceName));
            OutputStream outputStream = this.openOutputStream(resource, resourceName, executionContext);
            executionContext.put(resourceKey, (Object)outputStream);
            return outputStream;
        }
        if (resourceIOObj instanceof OutputStream) {
            return (OutputStream)resourceIOObj;
        }
        if (resourceIOObj instanceof Writer) {
            throw new SmooksException("An Writer to the '" + resourceName + "' resource is already open.  Cannot open an OutputStream to this resource now!");
        }
        throw new RuntimeException("Invalid runtime ExecutionContext state. Value stored under context key '" + resourceKey + "' must be either and OutputStream or Writer.  Is '" + resourceIOObj.getClass().getName() + "'.");
    }

    protected OutputStream openOutputStream(AbstractOutputStreamResource resource, String resourceName, ExecutionContext executionContext) {
        if (resource == null) {
            throw new SmooksException("OutputResource '" + resourceName + "' not bound to context.  Configure an '" + AbstractOutputStreamResource.class.getName() + "' implementation, or change resource ordering.");
        }
        try {
            return resource.getOutputStream(executionContext);
        }
        catch (IOException e) {
            throw new SmooksException("Unable to set outputstream for '" + resource.getResourceName() + "'.", (Throwable)e);
        }
    }

    public OutputStream getDelegateOutputStream() {
        return this.delegateOutputStream;
    }
}

