/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import com.fasterxml.aalto.AsyncByteArrayFeeder;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.smooks.api.SmooksException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriter
extends Writer {
    protected static final InputFactoryImpl ASYNC_XML_INPUT_FACTORY = new InputFactoryImpl();
    protected final ContentHandler contentHandler;
    protected final AsyncXMLStreamReader<AsyncByteArrayFeeder> asyncXMLStreamReader;
    protected final LexicalHandler lexicalHandler;

    public SAXWriter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)contentHandler) : null;
        this.asyncXMLStreamReader = ASYNC_XML_INPUT_FACTORY.createAsyncForByteArray();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            int event;
            ((AsyncByteArrayFeeder)this.asyncXMLStreamReader.getInputFeeder()).feedInput(new String(cbuf).getBytes(), off, len);
            block10: while (257 != (event = this.asyncXMLStreamReader.next())) {
                switch (event) {
                    case 7: {
                        this.contentHandler.startDocument();
                        break;
                    }
                    case 1: {
                        int i;
                        for (int i2 = 0; i2 < this.asyncXMLStreamReader.getNamespaceCount(); ++i2) {
                            this.contentHandler.startPrefixMapping(this.asyncXMLStreamReader.getNamespacePrefix(i2), this.asyncXMLStreamReader.getNamespaceURI(i2));
                        }
                        AttributesImpl saxAttributes = new AttributesImpl();
                        int n = this.asyncXMLStreamReader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            saxAttributes.addAttribute(this.asyncXMLStreamReader.getAttributeName(i).getNamespaceURI(), this.asyncXMLStreamReader.getAttributeName(i).getLocalPart(), this.asyncXMLStreamReader.getAttributeName(i).getPrefix() + ":" + this.asyncXMLStreamReader.getAttributeName(i).getLocalPart(), this.asyncXMLStreamReader.getAttributeType(i), this.asyncXMLStreamReader.getAttributeValue(i));
                        }
                        n = this.asyncXMLStreamReader.getNamespaceCount();
                        for (i = 0; i < n; ++i) {
                            saxAttributes.addAttribute("http://www.w3.org/2000/xmlns/", this.asyncXMLStreamReader.getNamespacePrefix(i), "xmlns:" + this.asyncXMLStreamReader.getNamespacePrefix(i), "CDATA", this.asyncXMLStreamReader.getNamespaceURI(i));
                        }
                        if (this.asyncXMLStreamReader.getName().getNamespaceURI().equals("")) {
                            this.contentHandler.startElement(this.asyncXMLStreamReader.getName().getNamespaceURI(), this.asyncXMLStreamReader.getName().getLocalPart(), this.asyncXMLStreamReader.getName().getLocalPart(), saxAttributes);
                            break;
                        }
                        this.contentHandler.startElement(this.asyncXMLStreamReader.getName().getNamespaceURI(), this.asyncXMLStreamReader.getName().getLocalPart(), this.asyncXMLStreamReader.getName().getPrefix() + ":" + this.asyncXMLStreamReader.getName().getLocalPart(), saxAttributes);
                        break;
                    }
                    case 4: {
                        this.contentHandler.characters(this.asyncXMLStreamReader.getText().toCharArray(), this.asyncXMLStreamReader.getTextStart(), this.asyncXMLStreamReader.getTextLength());
                        break;
                    }
                    case 12: {
                        if (this.lexicalHandler != null) {
                            this.lexicalHandler.startCDATA();
                        }
                        this.contentHandler.characters(this.asyncXMLStreamReader.getText().toCharArray(), this.asyncXMLStreamReader.getTextStart(), this.asyncXMLStreamReader.getTextLength());
                        if (this.lexicalHandler == null) continue block10;
                        this.lexicalHandler.endCDATA();
                        break;
                    }
                    case 2: {
                        int i;
                        if (this.asyncXMLStreamReader.getName().getNamespaceURI().equals("")) {
                            this.contentHandler.endElement(this.asyncXMLStreamReader.getName().getNamespaceURI(), this.asyncXMLStreamReader.getName().getLocalPart(), this.asyncXMLStreamReader.getName().getLocalPart());
                        } else {
                            this.contentHandler.endElement(this.asyncXMLStreamReader.getName().getNamespaceURI(), this.asyncXMLStreamReader.getName().getLocalPart(), this.asyncXMLStreamReader.getName().getPrefix() + ":" + this.asyncXMLStreamReader.getName().getLocalPart());
                        }
                        for (i = 0; i < this.asyncXMLStreamReader.getNamespaceCount(); ++i) {
                            this.contentHandler.endPrefixMapping(this.asyncXMLStreamReader.getNamespacePrefix(i));
                        }
                        continue block10;
                    }
                    case 8: {
                        this.contentHandler.endDocument();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        catch (XMLStreamException | SAXException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.asyncXMLStreamReader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    static {
        ASYNC_XML_INPUT_FACTORY.configureForLowMemUsage();
    }
}

