/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.Smooks;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.profile.UnknownProfileMemberException;
import org.smooks.assertion.AssertArgument;

public final class SmooksUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(Smooks.class);

    private SmooksUtil() {
    }

    public static void registerProfileSet(ProfileSet profileSet, Smooks smooks) {
        AssertArgument.isNotNull((Object)profileSet, (String)"profileSet");
        ProfileStore profileStore = smooks.getApplicationContext().getProfileStore();
        try {
            profileStore.getProfileSet(profileSet.getBaseProfile());
            LOGGER.debug("ProfileSet [" + profileSet.getBaseProfile() + "] already registered.  Not registering new profile set.");
        }
        catch (UnknownProfileMemberException e) {
            profileStore.addProfileSet(profileSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filterAndSerialize(ExecutionContext executionContext, InputStream stream, Smooks smooks) throws SmooksException {
        String responseBuf;
        try (CharArrayWriter writer = new CharArrayWriter();){
            smooks.filterSource(executionContext, new StreamSource(stream), new StreamResult(writer));
            responseBuf = writer.toString();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new SmooksException("Failed to close stream...", (Throwable)e);
                }
            }
        }
        return responseBuf;
    }
}

