/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.observation.transport.SenderContext;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;

public class KafkaRecordSenderContext
extends SenderContext<ProducerRecord<?, ?>> {
    private final String beanName;
    private final ProducerRecord<?, ?> record;

    public KafkaRecordSenderContext(ProducerRecord<?, ?> record, String beanName, Supplier<String> clusterId) {
        super((carrier, key, value) -> {
            Headers headers = record.headers();
            headers.remove(key);
            headers.add(key, value == null ? null : value.getBytes(StandardCharsets.UTF_8));
        });
        this.setCarrier(record);
        this.beanName = beanName;
        this.record = record;
        String cluster = clusterId.get();
        this.setRemoteServiceName("Apache Kafka" + (String)(cluster != null ? ": " + cluster : ""));
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDestination() {
        return this.record.topic();
    }

    public ProducerRecord<?, ?> getRecord() {
        return this.record;
    }
}

