/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.MessageId;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.log.LogAccessor;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.annotation.AbstractPulsarAnnotationsBeanPostProcessor;
import org.springframework.pulsar.annotation.PulsarReader;
import org.springframework.pulsar.annotation.PulsarReaderConfigurer;
import org.springframework.pulsar.annotation.PulsarReaderReaderBuilderCustomizer;
import org.springframework.pulsar.config.MethodPulsarReaderEndpoint;
import org.springframework.pulsar.config.PulsarReaderContainerFactory;
import org.springframework.pulsar.config.PulsarReaderEndpointRegistrar;
import org.springframework.pulsar.config.PulsarReaderEndpointRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PulsarReaderAnnotationBeanPostProcessor<V>
extends AbstractPulsarAnnotationsBeanPostProcessor
implements SmartInitializingSingleton {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    public static final String DEFAULT_PULSAR_READER_CONTAINER_FACTORY_BEAN_NAME = "pulsarReaderContainerFactory";
    private static final String GENERATED_ID_PREFIX = "org.springframework.Pulsar.PulsarReaderEndpointContainer#";
    private ApplicationContext applicationContext;
    private PulsarReaderEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "pulsarReaderContainerFactory";
    private final PulsarReaderEndpointRegistrar registrar = new PulsarReaderEndpointRegistrar(PulsarReaderContainerFactory.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final AtomicInteger counter = new AtomicInteger();
    private final List<MethodPulsarReaderEndpoint<?>> processedEndpoints = new ArrayList();

    public void afterSingletonsInstantiated() {
        this.registrar.setBeanFactory(this.beanFactory);
        this.beanFactory.getBeanProvider(PulsarReaderConfigurer.class).forEach(c -> c.configurePulsarReaders(this.registrar));
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (PulsarReaderEndpointRegistry)this.beanFactory.getBean("org.springframework.pulsar.config.internalPulsarReaderEndpointRegistry", PulsarReaderEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        this.addFormatters((FormatterRegistry)this.messageHandlerMethodFactory.defaultFormattingConversionService);
        this.postProcessEndpointsBeforeRegistration();
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<PulsarReader> readerMethods = this.findReaderAnnotations(method);
                return !readerMethods.isEmpty() ? readerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                this.logger.trace(() -> "No @PulsarReader annotations found on bean type: " + String.valueOf(bean.getClass()));
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (PulsarReader listener : (Set)entry.getValue()) {
                        this.processPulsarReader(listener, method2, bean, beanName);
                    }
                }
                this.logger.debug(() -> annotatedMethods.size() + " @PulsarListener methods processed on bean '" + beanName + "': " + String.valueOf(annotatedMethods));
            }
        }
        return bean;
    }

    protected void processPulsarReader(PulsarReader pulsarReader, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodPulsarReaderEndpoint endpoint = new MethodPulsarReaderEndpoint();
        endpoint.setMethod(methodToUse);
        String beanRef = pulsarReader.beanRef();
        this.listenerScope.addListener(beanRef, bean);
        String[] topics = this.resolveTopics(pulsarReader);
        this.processReader(endpoint, pulsarReader, bean, beanName, topics);
        this.listenerScope.removeListener(beanRef);
    }

    protected void processReader(MethodPulsarReaderEndpoint<?> endpoint, PulsarReader pulsarReader, Object bean, String beanName, String[] topics) {
        this.processPulsarReaderAnnotation(endpoint, pulsarReader, bean, topics);
        String containerFactory = this.resolve(pulsarReader.containerFactory());
        PulsarReaderContainerFactory listenerContainerFactory = this.resolveContainerFactory(pulsarReader, containerFactory, beanName);
        this.registrar.registerEndpoint(endpoint, listenerContainerFactory);
    }

    @Nullable
    private PulsarReaderContainerFactory resolveContainerFactory(PulsarReader pulsarReader, Object factoryTarget, String beanName) {
        String containerFactory = pulsarReader.containerFactory();
        if (!StringUtils.hasText((String)containerFactory)) {
            return null;
        }
        PulsarReaderContainerFactory factory = null;
        Object resolved = this.resolveExpression(containerFactory);
        if (resolved instanceof PulsarReaderContainerFactory) {
            return (PulsarReaderContainerFactory)resolved;
        }
        String containerFactoryBeanName = this.resolveExpressionAsString(containerFactory, "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (PulsarReaderContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, PulsarReaderContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, PulsarReaderContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    private void processPulsarReaderAnnotation(MethodPulsarReaderEndpoint<?> endpoint, PulsarReader pulsarReader, Object bean, String[] topics) {
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(pulsarReader));
        endpoint.setTopics(topics);
        endpoint.setSchemaType(pulsarReader.schemaType());
        String startMessageIdString = pulsarReader.startMessageId();
        MessageId startMessageId = null;
        if (startMessageIdString.equalsIgnoreCase("earliest")) {
            startMessageId = MessageId.earliest;
        } else if (startMessageIdString.equalsIgnoreCase("latest")) {
            startMessageId = MessageId.latest;
        }
        endpoint.setStartMessageId(startMessageId);
        String autoStartup = pulsarReader.autoStartup();
        if (StringUtils.hasText((String)autoStartup)) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup, "autoStartup"));
        }
        endpoint.setBeanFactory(this.beanFactory);
        this.resolveReaderCustomizer(endpoint, pulsarReader);
        this.processedEndpoints.add(endpoint);
    }

    protected void postProcessEndpointsBeforeRegistration() {
        if (this.processedEndpoints.size() == 1) {
            MethodPulsarReaderEndpoint<?> endpoint = this.processedEndpoints.get(0);
            if (endpoint.getReaderBuilderCustomizer() != null) {
                return;
            }
            this.beanFactory.getBeanProvider(PulsarReaderReaderBuilderCustomizer.class).ifUnique(customizer -> {
                this.logger.info(() -> String.format("Setting the only registered PulsarReaderReaderBuilderCustomizer on the only registered @PulsarReader (%s)", endpoint.getId()));
                endpoint.setReaderBuilderCustomizer(customizer::customize);
            });
        }
    }

    private void resolveReaderCustomizer(MethodPulsarReaderEndpoint<?> endpoint, PulsarReader pulsarReader) {
        if (!StringUtils.hasText((String)pulsarReader.readerCustomizer())) {
            return;
        }
        Object readerCustomizer = this.resolveExpression(pulsarReader.readerCustomizer());
        if (readerCustomizer instanceof PulsarReaderReaderBuilderCustomizer) {
            PulsarReaderReaderBuilderCustomizer customizer = (PulsarReaderReaderBuilderCustomizer)readerCustomizer;
            endpoint.setReaderBuilderCustomizer(customizer::customize);
        } else {
            String customizerBeanName = this.resolveExpressionAsString(pulsarReader.readerCustomizer(), "readerCustomizer");
            if (StringUtils.hasText((String)customizerBeanName)) {
                PulsarReaderReaderBuilderCustomizer customizer = (PulsarReaderReaderBuilderCustomizer)this.beanFactory.getBean(customizerBeanName, PulsarReaderReaderBuilderCustomizer.class);
                endpoint.setReaderBuilderCustomizer(customizer::customize);
            }
        }
    }

    private String getEndpointId(PulsarReader pulsarReader) {
        if (StringUtils.hasText((String)pulsarReader.id())) {
            return this.resolveExpressionAsString(pulsarReader.id(), "id");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String[] resolveTopics(PulsarReader PulsarListener2) {
        String[] topics = PulsarListener2.topics();
        ArrayList<String> result = new ArrayList<String>();
        if (topics.length > 0) {
            for (String topic1 : topics) {
                Object topic = this.resolveExpression(topic1);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[0]);
    }

    private Set<PulsarReader> findReaderAnnotations(Method method) {
        HashSet<PulsarReader> readers = new HashSet<PulsarReader>();
        PulsarReader ann = (PulsarReader)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PulsarReader.class);
        if (ann != null) {
            readers.add(ann);
        }
        return readers;
    }

    private void addFormatters(FormatterRegistry registry) {
        this.beanFactory.getBeanProvider(Converter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(GenericConverter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(Formatter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0));
    }
}

